/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.TerraformSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAppInputSourceRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, DeleteAppInputSourceRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(DeleteAppInputSourceRequest.getter(DeleteAppInputSourceRequest::appArn)).setter(DeleteAppInputSourceRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteAppInputSourceRequest.getter(DeleteAppInputSourceRequest::clientToken)).setter(DeleteAppInputSourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(DeleteAppInputSourceRequest.getter(DeleteAppInputSourceRequest::sourceArn)).setter(DeleteAppInputSourceRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<TerraformSource> TERRAFORM_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("terraformSource").getter(DeleteAppInputSourceRequest.getter(DeleteAppInputSourceRequest::terraformSource)).setter(DeleteAppInputSourceRequest.setter(Builder::terraformSource)).constructor(TerraformSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, CLIENT_TOKEN_FIELD, SOURCE_ARN_FIELD, TERRAFORM_SOURCE_FIELD));
    private final String appArn;
    private final String clientToken;
    private final String sourceArn;
    private final TerraformSource terraformSource;

    private DeleteAppInputSourceRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.clientToken = builder.clientToken;
        this.sourceArn = builder.sourceArn;
        this.terraformSource = builder.terraformSource;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final TerraformSource terraformSource() {
        return this.terraformSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.terraformSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppInputSourceRequest)) {
            return false;
        }
        DeleteAppInputSourceRequest other = (DeleteAppInputSourceRequest)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.terraformSource(), other.terraformSource());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAppInputSourceRequest").add("AppArn", (Object)this.appArn()).add("ClientToken", (Object)this.clientToken()).add("SourceArn", (Object)this.sourceArn()).add("TerraformSource", (Object)this.terraformSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "terraformSource": {
                return Optional.ofNullable(clazz.cast(this.terraformSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppInputSourceRequest, T> g) {
        return obj -> g.apply((DeleteAppInputSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String appArn;
        private String clientToken;
        private String sourceArn;
        private TerraformSource terraformSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppInputSourceRequest model) {
            super(model);
            this.appArn(model.appArn);
            this.clientToken(model.clientToken);
            this.sourceArn(model.sourceArn);
            this.terraformSource(model.terraformSource);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final TerraformSource.Builder getTerraformSource() {
            return this.terraformSource != null ? this.terraformSource.toBuilder() : null;
        }

        public final void setTerraformSource(TerraformSource.BuilderImpl terraformSource) {
            this.terraformSource = terraformSource != null ? terraformSource.build() : null;
        }

        @Override
        public final Builder terraformSource(TerraformSource terraformSource) {
            this.terraformSource = terraformSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppInputSourceRequest build() {
            return new DeleteAppInputSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAppInputSourceRequest> {
        public Builder appArn(String var1);

        public Builder clientToken(String var1);

        public Builder sourceArn(String var1);

        public Builder terraformSource(TerraformSource var1);

        default public Builder terraformSource(Consumer<TerraformSource.Builder> terraformSource) {
            return this.terraformSource((TerraformSource)((TerraformSource.Builder)TerraformSource.builder().applyMutation(terraformSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

