/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.TestRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.TestRecommendationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListTestRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestRecommendationsResponse.getter(ListTestRecommendationsResponse::nextToken)).setter(ListTestRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TestRecommendation>> TEST_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testRecommendations").getter(ListTestRecommendationsResponse.getter(ListTestRecommendationsResponse::testRecommendations)).setter(ListTestRecommendationsResponse.setter(Builder::testRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEST_RECOMMENDATIONS_FIELD));
    private final String nextToken;
    private final List<TestRecommendation> testRecommendations;

    private ListTestRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.testRecommendations = builder.testRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTestRecommendations() {
        return this.testRecommendations != null && !(this.testRecommendations instanceof SdkAutoConstructList);
    }

    public final List<TestRecommendation> testRecommendations() {
        return this.testRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestRecommendations() ? this.testRecommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRecommendationsResponse)) {
            return false;
        }
        ListTestRecommendationsResponse other = (ListTestRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTestRecommendations() == other.hasTestRecommendations() && Objects.equals(this.testRecommendations(), other.testRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("TestRecommendations", this.hasTestRecommendations() ? this.testRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "testRecommendations": {
                return Optional.ofNullable(clazz.cast(this.testRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRecommendationsResponse, T> g) {
        return obj -> g.apply((ListTestRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TestRecommendation> testRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.testRecommendations(model.testRecommendations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TestRecommendation.Builder> getTestRecommendations() {
            List<TestRecommendation.Builder> result = TestRecommendationListCopier.copyToBuilder(this.testRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestRecommendations(Collection<TestRecommendation.BuilderImpl> testRecommendations) {
            this.testRecommendations = TestRecommendationListCopier.copyFromBuilder(testRecommendations);
        }

        @Override
        @Transient
        public final Builder testRecommendations(Collection<TestRecommendation> testRecommendations) {
            this.testRecommendations = TestRecommendationListCopier.copy(testRecommendations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder testRecommendations(TestRecommendation ... testRecommendations) {
            this.testRecommendations(Arrays.asList(testRecommendations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder testRecommendations(Consumer<TestRecommendation.Builder> ... testRecommendations) {
            this.testRecommendations(Stream.of(testRecommendations).map(c -> (TestRecommendation)((TestRecommendation.Builder)TestRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTestRecommendationsResponse build() {
            return new ListTestRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder testRecommendations(Collection<TestRecommendation> var1);

        public Builder testRecommendations(TestRecommendation ... var1);

        public Builder testRecommendations(Consumer<TestRecommendation.Builder> ... var1);
    }
}

