/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.DataLocationConstraint;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionPolicyCopier;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.FailurePolicy;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubRequest;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyPolicyTier;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResiliencyPolicyRequest
extends ResiliencehubRequest
implements ToCopyableBuilder<Builder, CreateResiliencyPolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::clientToken)).setter(CreateResiliencyPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_LOCATION_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataLocationConstraint").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::dataLocationConstraintAsString)).setter(CreateResiliencyPolicyRequest.setter(Builder::dataLocationConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocationConstraint").build()}).build();
    private static final SdkField<Map<String, FailurePolicy>> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("policy").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::policyAsStrings)).setter(CreateResiliencyPolicyRequest.setter(Builder::policyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailurePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDescription").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::policyDescription)).setter(CreateResiliencyPolicyRequest.setter(Builder::policyDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDescription").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::policyName)).setter(CreateResiliencyPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::tags)).setter(CreateResiliencyPolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tier").getter(CreateResiliencyPolicyRequest.getter(CreateResiliencyPolicyRequest::tierAsString)).setter(CreateResiliencyPolicyRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_LOCATION_CONSTRAINT_FIELD, POLICY_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_NAME_FIELD, TAGS_FIELD, TIER_FIELD));
    private final String clientToken;
    private final String dataLocationConstraint;
    private final Map<String, FailurePolicy> policy;
    private final String policyDescription;
    private final String policyName;
    private final Map<String, String> tags;
    private final String tier;

    private CreateResiliencyPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataLocationConstraint = builder.dataLocationConstraint;
        this.policy = builder.policy;
        this.policyDescription = builder.policyDescription;
        this.policyName = builder.policyName;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DataLocationConstraint dataLocationConstraint() {
        return DataLocationConstraint.fromValue(this.dataLocationConstraint);
    }

    public final String dataLocationConstraintAsString() {
        return this.dataLocationConstraint;
    }

    public final Map<DisruptionType, FailurePolicy> policy() {
        return DisruptionPolicyCopier.copyStringToEnum(this.policy);
    }

    public final boolean hasPolicy() {
        return this.policy != null && !(this.policy instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailurePolicy> policyAsStrings() {
        return this.policy;
    }

    public final String policyDescription() {
        return this.policyDescription;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ResiliencyPolicyTier tier() {
        return ResiliencyPolicyTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicy() ? this.policyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResiliencyPolicyRequest)) {
            return false;
        }
        CreateResiliencyPolicyRequest other = (CreateResiliencyPolicyRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataLocationConstraintAsString(), other.dataLocationConstraintAsString()) && this.hasPolicy() == other.hasPolicy() && Objects.equals(this.policyAsStrings(), other.policyAsStrings()) && Objects.equals(this.policyDescription(), other.policyDescription()) && Objects.equals(this.policyName(), other.policyName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tierAsString(), other.tierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResiliencyPolicyRequest").add("ClientToken", (Object)this.clientToken()).add("DataLocationConstraint", (Object)this.dataLocationConstraintAsString()).add("Policy", this.hasPolicy() ? this.policyAsStrings() : null).add("PolicyDescription", (Object)this.policyDescription()).add("PolicyName", (Object)this.policyName()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("Tier", (Object)this.tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dataLocationConstraint": {
                return Optional.ofNullable(clazz.cast(this.dataLocationConstraintAsString()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policyAsStrings()));
            }
            case "policyDescription": {
                return Optional.ofNullable(clazz.cast(this.policyDescription()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResiliencyPolicyRequest, T> g) {
        return obj -> g.apply((CreateResiliencyPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataLocationConstraint;
        private Map<String, FailurePolicy> policy = DefaultSdkAutoConstructMap.getInstance();
        private String policyDescription;
        private String policyName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResiliencyPolicyRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataLocationConstraint(model.dataLocationConstraint);
            this.policyWithStrings(model.policy);
            this.policyDescription(model.policyDescription);
            this.policyName(model.policyName);
            this.tags(model.tags);
            this.tier(model.tier);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataLocationConstraint() {
            return this.dataLocationConstraint;
        }

        public final void setDataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
        }

        @Override
        @Transient
        public final Builder dataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        @Override
        @Transient
        public final Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
            this.dataLocationConstraint(dataLocationConstraint == null ? null : dataLocationConstraint.toString());
            return this;
        }

        public final Map<String, FailurePolicy.Builder> getPolicy() {
            Map<String, FailurePolicy.Builder> result = DisruptionPolicyCopier.copyToBuilder(this.policy);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPolicy(Map<String, FailurePolicy.BuilderImpl> policy) {
            this.policy = DisruptionPolicyCopier.copyFromBuilder(policy);
        }

        @Override
        @Transient
        public final Builder policyWithStrings(Map<String, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copy(policy);
            return this;
        }

        @Override
        @Transient
        public final Builder policy(Map<DisruptionType, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copyEnumToString(policy);
            return this;
        }

        public final String getPolicyDescription() {
            return this.policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        @Transient
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        @Transient
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        @Transient
        public final Builder tier(ResiliencyPolicyTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResiliencyPolicyRequest build() {
            return new CreateResiliencyPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResiliencyPolicyRequest> {
        public Builder clientToken(String var1);

        public Builder dataLocationConstraint(String var1);

        public Builder dataLocationConstraint(DataLocationConstraint var1);

        public Builder policyWithStrings(Map<String, FailurePolicy> var1);

        public Builder policy(Map<DisruptionType, FailurePolicy> var1);

        public Builder policyDescription(String var1);

        public Builder policyName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder tier(String var1);

        public Builder tier(ResiliencyPolicyTier var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

