/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The overall resiliency score, returned as an object that includes the disruption score and outage score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResiliencyScore implements SdkPojo, Serializable, ToCopyableBuilder<ResiliencyScore.Builder, ResiliencyScore> {
    private static final SdkField<Map<String, Double>> DISRUPTION_SCORE_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("disruptionScore")
            .getter(getter(ResiliencyScore::disruptionScoreAsStrings))
            .setter(setter(Builder::disruptionScoreWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disruptionScore").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(ResiliencyScore::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISRUPTION_SCORE_FIELD,
            SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Double> disruptionScore;

    private final Double score;

    private ResiliencyScore(BuilderImpl builder) {
        this.disruptionScore = builder.disruptionScore;
        this.score = builder.score;
    }

    /**
     * <p>
     * The disruption score for a valid key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisruptionScore} method.
     * </p>
     * 
     * @return The disruption score for a valid key.
     */
    public final Map<DisruptionType, Double> disruptionScore() {
        return DisruptionResiliencyScoreCopier.copyStringToEnum(disruptionScore);
    }

    /**
     * For responses, this returns true if the service returned a value for the DisruptionScore property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisruptionScore() {
        return disruptionScore != null && !(disruptionScore instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The disruption score for a valid key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisruptionScore} method.
     * </p>
     * 
     * @return The disruption score for a valid key.
     */
    public final Map<String, Double> disruptionScoreAsStrings() {
        return disruptionScore;
    }

    /**
     * <p>
     * The outage score for a valid key.
     * </p>
     * 
     * @return The outage score for a valid key.
     */
    public final Double score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDisruptionScore() ? disruptionScoreAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResiliencyScore)) {
            return false;
        }
        ResiliencyScore other = (ResiliencyScore) obj;
        return hasDisruptionScore() == other.hasDisruptionScore()
                && Objects.equals(disruptionScoreAsStrings(), other.disruptionScoreAsStrings())
                && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResiliencyScore")
                .add("DisruptionScore", hasDisruptionScore() ? disruptionScoreAsStrings() : null).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disruptionScore":
            return Optional.ofNullable(clazz.cast(disruptionScoreAsStrings()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResiliencyScore, T> g) {
        return obj -> g.apply((ResiliencyScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResiliencyScore> {
        /**
         * <p>
         * The disruption score for a valid key.
         * </p>
         * 
         * @param disruptionScore
         *        The disruption score for a valid key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disruptionScoreWithStrings(Map<String, Double> disruptionScore);

        /**
         * <p>
         * The disruption score for a valid key.
         * </p>
         * 
         * @param disruptionScore
         *        The disruption score for a valid key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disruptionScore(Map<DisruptionType, Double> disruptionScore);

        /**
         * <p>
         * The outage score for a valid key.
         * </p>
         * 
         * @param score
         *        The outage score for a valid key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Double> disruptionScore = DefaultSdkAutoConstructMap.getInstance();

        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(ResiliencyScore model) {
            disruptionScoreWithStrings(model.disruptionScore);
            score(model.score);
        }

        public final Map<String, Double> getDisruptionScore() {
            if (disruptionScore instanceof SdkAutoConstructMap) {
                return null;
            }
            return disruptionScore;
        }

        public final void setDisruptionScore(Map<String, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copy(disruptionScore);
        }

        @Override
        @Transient
        public final Builder disruptionScoreWithStrings(Map<String, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copy(disruptionScore);
            return this;
        }

        @Override
        @Transient
        public final Builder disruptionScore(Map<DisruptionType, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copyEnumToString(disruptionScore);
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        @Override
        public ResiliencyScore build() {
            return new ResiliencyScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
