/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a logical resource identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogicalResourceId implements SdkPojo, Serializable,
        ToCopyableBuilder<LogicalResourceId.Builder, LogicalResourceId> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(LogicalResourceId::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logicalStackName").getter(getter(LogicalResourceId::logicalStackName))
            .setter(setter(Builder::logicalStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()).build();

    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGroupName").getter(getter(LogicalResourceId::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LOGICAL_STACK_NAME_FIELD, RESOURCE_GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String logicalStackName;

    private final String resourceGroupName;

    private LogicalResourceId(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.logicalStackName = builder.logicalStackName;
        this.resourceGroupName = builder.resourceGroupName;
    }

    /**
     * <p>
     * The identifier of the resource.
     * </p>
     * 
     * @return The identifier of the resource.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the CloudFormation stack this resource belongs to.
     * </p>
     * 
     * @return The name of the CloudFormation stack this resource belongs to.
     */
    public final String logicalStackName() {
        return logicalStackName;
    }

    /**
     * <p>
     * The name of the resource group that this resource belongs to.
     * </p>
     * 
     * @return The name of the resource group that this resource belongs to.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalResourceId)) {
            return false;
        }
        LogicalResourceId other = (LogicalResourceId) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(logicalStackName(), other.logicalStackName())
                && Objects.equals(resourceGroupName(), other.resourceGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogicalResourceId").add("Identifier", identifier()).add("LogicalStackName", logicalStackName())
                .add("ResourceGroupName", resourceGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "logicalStackName":
            return Optional.ofNullable(clazz.cast(logicalStackName()));
        case "resourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogicalResourceId, T> g) {
        return obj -> g.apply((LogicalResourceId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogicalResourceId> {
        /**
         * <p>
         * The identifier of the resource.
         * </p>
         * 
         * @param identifier
         *        The identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the CloudFormation stack this resource belongs to.
         * </p>
         * 
         * @param logicalStackName
         *        The name of the CloudFormation stack this resource belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalStackName(String logicalStackName);

        /**
         * <p>
         * The name of the resource group that this resource belongs to.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group that this resource belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String logicalStackName;

        private String resourceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalResourceId model) {
            identifier(model.identifier);
            logicalStackName(model.logicalStackName);
            resourceGroupName(model.resourceGroupName);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLogicalStackName() {
            return logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        @Transient
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        @Transient
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        @Override
        public LogicalResourceId build() {
            return new LogicalResourceId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
