/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a failure policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailurePolicy implements SdkPojo, Serializable, ToCopyableBuilder<FailurePolicy.Builder, FailurePolicy> {
    private static final SdkField<Integer> RPO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rpoInSecs").getter(getter(FailurePolicy::rpoInSecs)).setter(setter(Builder::rpoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rpoInSecs").build()).build();

    private static final SdkField<Integer> RTO_IN_SECS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rtoInSecs").getter(getter(FailurePolicy::rtoInSecs)).setter(setter(Builder::rtoInSecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtoInSecs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RPO_IN_SECS_FIELD,
            RTO_IN_SECS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer rpoInSecs;

    private final Integer rtoInSecs;

    private FailurePolicy(BuilderImpl builder) {
        this.rpoInSecs = builder.rpoInSecs;
        this.rtoInSecs = builder.rtoInSecs;
    }

    /**
     * <p>
     * The Recovery Point Objective (RPO), in seconds.
     * </p>
     * 
     * @return The Recovery Point Objective (RPO), in seconds.
     */
    public final Integer rpoInSecs() {
        return rpoInSecs;
    }

    /**
     * <p>
     * The Recovery Time Objective (RTO), in seconds.
     * </p>
     * 
     * @return The Recovery Time Objective (RTO), in seconds.
     */
    public final Integer rtoInSecs() {
        return rtoInSecs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rpoInSecs());
        hashCode = 31 * hashCode + Objects.hashCode(rtoInSecs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailurePolicy)) {
            return false;
        }
        FailurePolicy other = (FailurePolicy) obj;
        return Objects.equals(rpoInSecs(), other.rpoInSecs()) && Objects.equals(rtoInSecs(), other.rtoInSecs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailurePolicy").add("RpoInSecs", rpoInSecs()).add("RtoInSecs", rtoInSecs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rpoInSecs":
            return Optional.ofNullable(clazz.cast(rpoInSecs()));
        case "rtoInSecs":
            return Optional.ofNullable(clazz.cast(rtoInSecs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailurePolicy, T> g) {
        return obj -> g.apply((FailurePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailurePolicy> {
        /**
         * <p>
         * The Recovery Point Objective (RPO), in seconds.
         * </p>
         * 
         * @param rpoInSecs
         *        The Recovery Point Objective (RPO), in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rpoInSecs(Integer rpoInSecs);

        /**
         * <p>
         * The Recovery Time Objective (RTO), in seconds.
         * </p>
         * 
         * @param rtoInSecs
         *        The Recovery Time Objective (RTO), in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtoInSecs(Integer rtoInSecs);
    }

    static final class BuilderImpl implements Builder {
        private Integer rpoInSecs;

        private Integer rtoInSecs;

        private BuilderImpl() {
        }

        private BuilderImpl(FailurePolicy model) {
            rpoInSecs(model.rpoInSecs);
            rtoInSecs(model.rtoInSecs);
        }

        public final Integer getRpoInSecs() {
            return rpoInSecs;
        }

        public final void setRpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
        }

        @Override
        @Transient
        public final Builder rpoInSecs(Integer rpoInSecs) {
            this.rpoInSecs = rpoInSecs;
            return this;
        }

        public final Integer getRtoInSecs() {
            return rtoInSecs;
        }

        public final void setRtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
        }

        @Override
        @Transient
        public final Builder rtoInSecs(Integer rtoInSecs) {
            this.rtoInSecs = rtoInSecs;
            return this;
        }

        @Override
        public FailurePolicy build() {
            return new FailurePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
