/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResiliencyPolicyRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<CreateResiliencyPolicyRequest.Builder, CreateResiliencyPolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateResiliencyPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATA_LOCATION_CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLocationConstraint").getter(getter(CreateResiliencyPolicyRequest::dataLocationConstraintAsString))
            .setter(setter(Builder::dataLocationConstraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocationConstraint").build())
            .build();

    private static final SdkField<Map<String, FailurePolicy>> POLICY_FIELD = SdkField
            .<Map<String, FailurePolicy>> builder(MarshallingType.MAP)
            .memberName("policy")
            .getter(getter(CreateResiliencyPolicyRequest::policyAsStrings))
            .setter(setter(Builder::policyWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailurePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailurePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDescription").getter(getter(CreateResiliencyPolicyRequest::policyDescription))
            .setter(setter(Builder::policyDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDescription").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(CreateResiliencyPolicyRequest::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateResiliencyPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(CreateResiliencyPolicyRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_LOCATION_CONSTRAINT_FIELD, POLICY_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_NAME_FIELD, TAGS_FIELD, TIER_FIELD));

    private final String clientToken;

    private final String dataLocationConstraint;

    private final Map<String, FailurePolicy> policy;

    private final String policyDescription;

    private final String policyName;

    private final Map<String, String> tags;

    private final String tier;

    private CreateResiliencyPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataLocationConstraint = builder.dataLocationConstraint;
        this.policy = builder.policy;
        this.policyDescription = builder.policyDescription;
        this.policyName = builder.policyName;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    /**
     * <p>
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
     * You should not reuse the same client token for other API requests.
     * </p>
     * 
     * @return Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
     *         characters. You should not reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataLocationConstraint} will return {@link DataLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataLocationConstraintAsString}.
     * </p>
     * 
     * @return Specifies a high-level geographical location constraint for where your resilience policy data can be
     *         stored.
     * @see DataLocationConstraint
     */
    public final DataLocationConstraint dataLocationConstraint() {
        return DataLocationConstraint.fromValue(dataLocationConstraint);
    }

    /**
     * <p>
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataLocationConstraint} will return {@link DataLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataLocationConstraintAsString}.
     * </p>
     * 
     * @return Specifies a high-level geographical location constraint for where your resilience policy data can be
     *         stored.
     * @see DataLocationConstraint
     */
    public final String dataLocationConstraintAsString() {
        return dataLocationConstraint;
    }

    /**
     * <p>
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
     * objective (RPO) in seconds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicy} method.
     * </p>
     * 
     * @return The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
     *         point objective (RPO) in seconds.
     */
    public final Map<DisruptionType, FailurePolicy> policy() {
        return DisruptionPolicyCopier.copyStringToEnum(policy);
    }

    /**
     * For responses, this returns true if the service returned a value for the Policy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicy() {
        return policy != null && !(policy instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
     * objective (RPO) in seconds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicy} method.
     * </p>
     * 
     * @return The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
     *         point objective (RPO) in seconds.
     */
    public final Map<String, FailurePolicy> policyAsStrings() {
        return policy;
    }

    /**
     * <p>
     * The description for the policy.
     * </p>
     * 
     * @return The description for the policy.
     */
    public final String policyDescription() {
        return policyDescription;
    }

    /**
     * <p>
     * The name of the policy
     * </p>
     * 
     * @return The name of the policy
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
     *         Each tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (
     * <code>NonCritical</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link ResiliencyPolicyTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
     *         lowest (<code>NonCritical</code>).
     * @see ResiliencyPolicyTier
     */
    public final ResiliencyPolicyTier tier() {
        return ResiliencyPolicyTier.fromValue(tier);
    }

    /**
     * <p>
     * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (
     * <code>NonCritical</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link ResiliencyPolicyTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
     *         lowest (<code>NonCritical</code>).
     * @see ResiliencyPolicyTier
     */
    public final String tierAsString() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataLocationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicy() ? policyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResiliencyPolicyRequest)) {
            return false;
        }
        CreateResiliencyPolicyRequest other = (CreateResiliencyPolicyRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dataLocationConstraintAsString(), other.dataLocationConstraintAsString())
                && hasPolicy() == other.hasPolicy() && Objects.equals(policyAsStrings(), other.policyAsStrings())
                && Objects.equals(policyDescription(), other.policyDescription())
                && Objects.equals(policyName(), other.policyName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(tierAsString(), other.tierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResiliencyPolicyRequest").add("ClientToken", clientToken())
                .add("DataLocationConstraint", dataLocationConstraintAsString())
                .add("Policy", hasPolicy() ? policyAsStrings() : null).add("PolicyDescription", policyDescription())
                .add("PolicyName", policyName()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tier", tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "dataLocationConstraint":
            return Optional.ofNullable(clazz.cast(dataLocationConstraintAsString()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policyAsStrings()));
        case "policyDescription":
            return Optional.ofNullable(clazz.cast(policyDescription()));
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResiliencyPolicyRequest, T> g) {
        return obj -> g.apply((CreateResiliencyPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResiliencyPolicyRequest> {
        /**
         * <p>
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         * characters. You should not reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         *        characters. You should not reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         * </p>
         * 
         * @param dataLocationConstraint
         *        Specifies a high-level geographical location constraint for where your resilience policy data can be
         *        stored.
         * @see DataLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLocationConstraint
         */
        Builder dataLocationConstraint(String dataLocationConstraint);

        /**
         * <p>
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         * </p>
         * 
         * @param dataLocationConstraint
         *        Specifies a high-level geographical location constraint for where your resilience policy data can be
         *        stored.
         * @see DataLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLocationConstraint
         */
        Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint);

        /**
         * <p>
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds.
         * </p>
         * 
         * @param policy
         *        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
         *        point objective (RPO) in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyWithStrings(Map<String, FailurePolicy> policy);

        /**
         * <p>
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds.
         * </p>
         * 
         * @param policy
         *        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
         *        point objective (RPO) in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(Map<DisruptionType, FailurePolicy> policy);

        /**
         * <p>
         * The description for the policy.
         * </p>
         * 
         * @param policyDescription
         *        The description for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDescription(String policyDescription);

        /**
         * <p>
         * The name of the policy
         * </p>
         * 
         * @param policyName
         *        The name of the policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
         * tag consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
         * lowest (<code>NonCritical</code>).
         * </p>
         * 
         * @param tier
         *        The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>)
         *        to lowest (<code>NonCritical</code>).
         * @see ResiliencyPolicyTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResiliencyPolicyTier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
         * lowest (<code>NonCritical</code>).
         * </p>
         * 
         * @param tier
         *        The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>)
         *        to lowest (<code>NonCritical</code>).
         * @see ResiliencyPolicyTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResiliencyPolicyTier
         */
        Builder tier(ResiliencyPolicyTier tier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String dataLocationConstraint;

        private Map<String, FailurePolicy> policy = DefaultSdkAutoConstructMap.getInstance();

        private String policyDescription;

        private String policyName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResiliencyPolicyRequest model) {
            super(model);
            clientToken(model.clientToken);
            dataLocationConstraint(model.dataLocationConstraint);
            policyWithStrings(model.policy);
            policyDescription(model.policyDescription);
            policyName(model.policyName);
            tags(model.tags);
            tier(model.tier);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataLocationConstraint() {
            return dataLocationConstraint;
        }

        public final void setDataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
        }

        @Override
        @Transient
        public final Builder dataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        @Override
        @Transient
        public final Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
            this.dataLocationConstraint(dataLocationConstraint == null ? null : dataLocationConstraint.toString());
            return this;
        }

        public final Map<String, FailurePolicy.Builder> getPolicy() {
            Map<String, FailurePolicy.Builder> result = DisruptionPolicyCopier.copyToBuilder(this.policy);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPolicy(Map<String, FailurePolicy.BuilderImpl> policy) {
            this.policy = DisruptionPolicyCopier.copyFromBuilder(policy);
        }

        @Override
        @Transient
        public final Builder policyWithStrings(Map<String, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copy(policy);
            return this;
        }

        @Override
        @Transient
        public final Builder policy(Map<DisruptionType, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copyEnumToString(policy);
            return this;
        }

        public final String getPolicyDescription() {
            return policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        @Transient
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        @Transient
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        @Transient
        public final Builder tier(ResiliencyPolicyTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResiliencyPolicyRequest build() {
            return new CreateResiliencyPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
