/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a configuration recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigRecommendation.Builder, ConfigRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(ConfigRecommendation::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField
            .<Map<String, DisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("compliance")
            .getter(getter(ConfigRecommendation::complianceAsStrings))
            .setter(setter(Builder::complianceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Cost> COST_FIELD = SdkField.<Cost> builder(MarshallingType.SDK_POJO).memberName("cost")
            .getter(getter(ConfigRecommendation::cost)).setter(setter(Builder::cost)).constructor(Cost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConfigRecommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> HA_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("haArchitecture").getter(getter(ConfigRecommendation::haArchitectureAsString))
            .setter(setter(Builder::haArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("haArchitecture").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfigRecommendation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OPTIMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("optimizationType").getter(getter(ConfigRecommendation::optimizationTypeAsString))
            .setter(setter(Builder::optimizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optimizationType").build()).build();

    private static final SdkField<Map<String, RecommendationDisruptionCompliance>> RECOMMENDATION_COMPLIANCE_FIELD = SdkField
            .<Map<String, RecommendationDisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("recommendationCompliance")
            .getter(getter(ConfigRecommendation::recommendationComplianceAsStrings))
            .setter(setter(Builder::recommendationComplianceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationCompliance").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RecommendationDisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationDisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceId").getter(getter(ConfigRecommendation::referenceId)).setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()).build();

    private static final SdkField<List<String>> SUGGESTED_CHANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("suggestedChanges")
            .getter(getter(ConfigRecommendation::suggestedChanges))
            .setter(setter(Builder::suggestedChanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedChanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD,
            COMPLIANCE_FIELD, COST_FIELD, DESCRIPTION_FIELD, HA_ARCHITECTURE_FIELD, NAME_FIELD, OPTIMIZATION_TYPE_FIELD,
            RECOMMENDATION_COMPLIANCE_FIELD, REFERENCE_ID_FIELD, SUGGESTED_CHANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentName;

    private final Map<String, DisruptionCompliance> compliance;

    private final Cost cost;

    private final String description;

    private final String haArchitecture;

    private final String name;

    private final String optimizationType;

    private final Map<String, RecommendationDisruptionCompliance> recommendationCompliance;

    private final String referenceId;

    private final List<String> suggestedChanges;

    private ConfigRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.compliance = builder.compliance;
        this.cost = builder.cost;
        this.description = builder.description;
        this.haArchitecture = builder.haArchitecture;
        this.name = builder.name;
        this.optimizationType = builder.optimizationType;
        this.recommendationCompliance = builder.recommendationCompliance;
        this.referenceId = builder.referenceId;
        this.suggestedChanges = builder.suggestedChanges;
    }

    /**
     * <p>
     * The application component name.
     * </p>
     * 
     * @return The application component name.
     */
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * <p>
     * The current compliance against the resiliency policy before applying the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return The current compliance against the resiliency policy before applying the configuration change.
     */
    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(compliance);
    }

    /**
     * For responses, this returns true if the service returned a value for the Compliance property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCompliance() {
        return compliance != null && !(compliance instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The current compliance against the resiliency policy before applying the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return The current compliance against the resiliency policy before applying the configuration change.
     */
    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return compliance;
    }

    /**
     * <p>
     * The cost for the application.
     * </p>
     * 
     * @return The cost for the application.
     */
    public final Cost cost() {
        return cost;
    }

    /**
     * <p>
     * The optional description for an app.
     * </p>
     * 
     * @return The optional description for an app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The architecture type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #haArchitecture}
     * will return {@link HaArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #haArchitectureAsString}.
     * </p>
     * 
     * @return The architecture type.
     * @see HaArchitecture
     */
    public final HaArchitecture haArchitecture() {
        return HaArchitecture.fromValue(haArchitecture);
    }

    /**
     * <p>
     * The architecture type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #haArchitecture}
     * will return {@link HaArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #haArchitectureAsString}.
     * </p>
     * 
     * @return The architecture type.
     * @see HaArchitecture
     */
    public final String haArchitectureAsString() {
        return haArchitecture;
    }

    /**
     * <p>
     * The name of the recommendation configuration.
     * </p>
     * 
     * @return The name of the recommendation configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of optimization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optimizationType}
     * will return {@link ConfigRecommendationOptimizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #optimizationTypeAsString}.
     * </p>
     * 
     * @return The type of optimization.
     * @see ConfigRecommendationOptimizationType
     */
    public final ConfigRecommendationOptimizationType optimizationType() {
        return ConfigRecommendationOptimizationType.fromValue(optimizationType);
    }

    /**
     * <p>
     * The type of optimization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optimizationType}
     * will return {@link ConfigRecommendationOptimizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #optimizationTypeAsString}.
     * </p>
     * 
     * @return The type of optimization.
     * @see ConfigRecommendationOptimizationType
     */
    public final String optimizationTypeAsString() {
        return optimizationType;
    }

    /**
     * <p>
     * The expected compliance against the resiliency policy after applying the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationCompliance} method.
     * </p>
     * 
     * @return The expected compliance against the resiliency policy after applying the configuration change.
     */
    public final Map<DisruptionType, RecommendationDisruptionCompliance> recommendationCompliance() {
        return RecommendationComplianceCopier.copyStringToEnum(recommendationCompliance);
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationCompliance property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecommendationCompliance() {
        return recommendationCompliance != null && !(recommendationCompliance instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The expected compliance against the resiliency policy after applying the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationCompliance} method.
     * </p>
     * 
     * @return The expected compliance against the resiliency policy after applying the configuration change.
     */
    public final Map<String, RecommendationDisruptionCompliance> recommendationComplianceAsStrings() {
        return recommendationCompliance;
    }

    /**
     * <p>
     * The reference identifier for the recommendation configuration.
     * </p>
     * 
     * @return The reference identifier for the recommendation configuration.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestedChanges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestedChanges() {
        return suggestedChanges != null && !(suggestedChanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the suggested configuration changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestedChanges} method.
     * </p>
     * 
     * @return List of the suggested configuration changes.
     */
    public final List<String> suggestedChanges() {
        return suggestedChanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompliance() ? complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(haArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationCompliance() ? recommendationComplianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestedChanges() ? suggestedChanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRecommendation)) {
            return false;
        }
        ConfigRecommendation other = (ConfigRecommendation) obj;
        return Objects.equals(appComponentName(), other.appComponentName()) && hasCompliance() == other.hasCompliance()
                && Objects.equals(complianceAsStrings(), other.complianceAsStrings()) && Objects.equals(cost(), other.cost())
                && Objects.equals(description(), other.description())
                && Objects.equals(haArchitectureAsString(), other.haArchitectureAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(optimizationTypeAsString(), other.optimizationTypeAsString())
                && hasRecommendationCompliance() == other.hasRecommendationCompliance()
                && Objects.equals(recommendationComplianceAsStrings(), other.recommendationComplianceAsStrings())
                && Objects.equals(referenceId(), other.referenceId()) && hasSuggestedChanges() == other.hasSuggestedChanges()
                && Objects.equals(suggestedChanges(), other.suggestedChanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigRecommendation").add("AppComponentName", appComponentName())
                .add("Compliance", hasCompliance() ? complianceAsStrings() : null).add("Cost", cost())
                .add("Description", description()).add("HaArchitecture", haArchitectureAsString()).add("Name", name())
                .add("OptimizationType", optimizationTypeAsString())
                .add("RecommendationCompliance", hasRecommendationCompliance() ? recommendationComplianceAsStrings() : null)
                .add("ReferenceId", referenceId()).add("SuggestedChanges", hasSuggestedChanges() ? suggestedChanges() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "compliance":
            return Optional.ofNullable(clazz.cast(complianceAsStrings()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "haArchitecture":
            return Optional.ofNullable(clazz.cast(haArchitectureAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "optimizationType":
            return Optional.ofNullable(clazz.cast(optimizationTypeAsString()));
        case "recommendationCompliance":
            return Optional.ofNullable(clazz.cast(recommendationComplianceAsStrings()));
        case "referenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "suggestedChanges":
            return Optional.ofNullable(clazz.cast(suggestedChanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigRecommendation, T> g) {
        return obj -> g.apply((ConfigRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigRecommendation> {
        /**
         * <p>
         * The application component name.
         * </p>
         * 
         * @param appComponentName
         *        The application component name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * The current compliance against the resiliency policy before applying the configuration change.
         * </p>
         * 
         * @param compliance
         *        The current compliance against the resiliency policy before applying the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance);

        /**
         * <p>
         * The current compliance against the resiliency policy before applying the configuration change.
         * </p>
         * 
         * @param compliance
         *        The current compliance against the resiliency policy before applying the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * 
         * @param cost
         *        The cost for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Cost cost);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * This is a convenience that creates an instance of the {@link Cost.Builder} avoiding the need to create one
         * manually via {@link Cost#builder()}.
         *
         * When the {@link Consumer} completes, {@link Cost.Builder#build()} is called immediately and its result is
         * passed to {@link #cost(Cost)}.
         * 
         * @param cost
         *        a consumer that will call methods on {@link Cost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cost(Cost)
         */
        default Builder cost(Consumer<Cost.Builder> cost) {
            return cost(Cost.builder().applyMutation(cost).build());
        }

        /**
         * <p>
         * The optional description for an app.
         * </p>
         * 
         * @param description
         *        The optional description for an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param haArchitecture
         *        The architecture type.
         * @see HaArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HaArchitecture
         */
        Builder haArchitecture(String haArchitecture);

        /**
         * <p>
         * The architecture type.
         * </p>
         * 
         * @param haArchitecture
         *        The architecture type.
         * @see HaArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HaArchitecture
         */
        Builder haArchitecture(HaArchitecture haArchitecture);

        /**
         * <p>
         * The name of the recommendation configuration.
         * </p>
         * 
         * @param name
         *        The name of the recommendation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of optimization.
         * </p>
         * 
         * @param optimizationType
         *        The type of optimization.
         * @see ConfigRecommendationOptimizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRecommendationOptimizationType
         */
        Builder optimizationType(String optimizationType);

        /**
         * <p>
         * The type of optimization.
         * </p>
         * 
         * @param optimizationType
         *        The type of optimization.
         * @see ConfigRecommendationOptimizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigRecommendationOptimizationType
         */
        Builder optimizationType(ConfigRecommendationOptimizationType optimizationType);

        /**
         * <p>
         * The expected compliance against the resiliency policy after applying the configuration change.
         * </p>
         * 
         * @param recommendationCompliance
         *        The expected compliance against the resiliency policy after applying the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationComplianceWithStrings(Map<String, RecommendationDisruptionCompliance> recommendationCompliance);

        /**
         * <p>
         * The expected compliance against the resiliency policy after applying the configuration change.
         * </p>
         * 
         * @param recommendationCompliance
         *        The expected compliance against the resiliency policy after applying the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationCompliance(Map<DisruptionType, RecommendationDisruptionCompliance> recommendationCompliance);

        /**
         * <p>
         * The reference identifier for the recommendation configuration.
         * </p>
         * 
         * @param referenceId
         *        The reference identifier for the recommendation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * List of the suggested configuration changes.
         * </p>
         * 
         * @param suggestedChanges
         *        List of the suggested configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedChanges(Collection<String> suggestedChanges);

        /**
         * <p>
         * List of the suggested configuration changes.
         * </p>
         * 
         * @param suggestedChanges
         *        List of the suggested configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedChanges(String... suggestedChanges);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentName;

        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();

        private Cost cost;

        private String description;

        private String haArchitecture;

        private String name;

        private String optimizationType;

        private Map<String, RecommendationDisruptionCompliance> recommendationCompliance = DefaultSdkAutoConstructMap
                .getInstance();

        private String referenceId;

        private List<String> suggestedChanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRecommendation model) {
            appComponentName(model.appComponentName);
            complianceWithStrings(model.compliance);
            cost(model.cost);
            description(model.description);
            haArchitecture(model.haArchitecture);
            name(model.name);
            optimizationType(model.optimizationType);
            recommendationComplianceWithStrings(model.recommendationCompliance);
            referenceId(model.referenceId);
            suggestedChanges(model.suggestedChanges);
        }

        public final String getAppComponentName() {
            return appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        @Transient
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        @Transient
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        @Transient
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final Cost.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        @Transient
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHaArchitecture() {
            return haArchitecture;
        }

        public final void setHaArchitecture(String haArchitecture) {
            this.haArchitecture = haArchitecture;
        }

        @Override
        @Transient
        public final Builder haArchitecture(String haArchitecture) {
            this.haArchitecture = haArchitecture;
            return this;
        }

        @Override
        @Transient
        public final Builder haArchitecture(HaArchitecture haArchitecture) {
            this.haArchitecture(haArchitecture == null ? null : haArchitecture.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOptimizationType() {
            return optimizationType;
        }

        public final void setOptimizationType(String optimizationType) {
            this.optimizationType = optimizationType;
        }

        @Override
        @Transient
        public final Builder optimizationType(String optimizationType) {
            this.optimizationType = optimizationType;
            return this;
        }

        @Override
        @Transient
        public final Builder optimizationType(ConfigRecommendationOptimizationType optimizationType) {
            this.optimizationType(optimizationType == null ? null : optimizationType.toString());
            return this;
        }

        public final Map<String, RecommendationDisruptionCompliance.Builder> getRecommendationCompliance() {
            Map<String, RecommendationDisruptionCompliance.Builder> result = RecommendationComplianceCopier
                    .copyToBuilder(this.recommendationCompliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRecommendationCompliance(
                Map<String, RecommendationDisruptionCompliance.BuilderImpl> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copyFromBuilder(recommendationCompliance);
        }

        @Override
        @Transient
        public final Builder recommendationComplianceWithStrings(
                Map<String, RecommendationDisruptionCompliance> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copy(recommendationCompliance);
            return this;
        }

        @Override
        @Transient
        public final Builder recommendationCompliance(
                Map<DisruptionType, RecommendationDisruptionCompliance> recommendationCompliance) {
            this.recommendationCompliance = RecommendationComplianceCopier.copyEnumToString(recommendationCompliance);
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        @Transient
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final Collection<String> getSuggestedChanges() {
            if (suggestedChanges instanceof SdkAutoConstructList) {
                return null;
            }
            return suggestedChanges;
        }

        public final void setSuggestedChanges(Collection<String> suggestedChanges) {
            this.suggestedChanges = SuggestedChangesListCopier.copy(suggestedChanges);
        }

        @Override
        @Transient
        public final Builder suggestedChanges(Collection<String> suggestedChanges) {
            this.suggestedChanges = SuggestedChangesListCopier.copy(suggestedChanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder suggestedChanges(String... suggestedChanges) {
            suggestedChanges(Arrays.asList(suggestedChanges));
            return this;
        }

        @Override
        public ConfigRecommendation build() {
            return new ConfigRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
