/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionResourcesResponse;

public class ListAppVersionResourcesIterable
implements SdkIterable<ListAppVersionResourcesResponse> {
    private final ResiliencehubClient client;
    private final ListAppVersionResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppVersionResourcesIterable(ResiliencehubClient client, ListAppVersionResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppVersionResourcesResponseFetcher();
    }

    public Iterator<ListAppVersionResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppVersionResourcesResponseFetcher
    implements SyncPageFetcher<ListAppVersionResourcesResponse> {
        private ListAppVersionResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppVersionResourcesResponse nextPage(ListAppVersionResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionResourcesIterable.this.client.listAppVersionResources(ListAppVersionResourcesIterable.this.firstRequest);
            }
            return ListAppVersionResourcesIterable.this.client.listAppVersionResources((ListAppVersionResourcesRequest)((Object)ListAppVersionResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

