/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.repostspace.RepostspaceAsyncClient;
import software.amazon.awssdk.services.repostspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.repostspace.model.ListSpacesRequest;
import software.amazon.awssdk.services.repostspace.model.ListSpacesResponse;
import software.amazon.awssdk.services.repostspace.model.SpaceData;

public class ListSpacesPublisher
implements SdkPublisher<ListSpacesResponse> {
    private final RepostspaceAsyncClient client;
    private final ListSpacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSpacesPublisher(RepostspaceAsyncClient client, ListSpacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSpacesPublisher(RepostspaceAsyncClient client, ListSpacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSpacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSpacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpaceData> spaces() {
        Function<ListSpacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.spaces() != null) {
                return response.spaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSpacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSpacesResponseFetcher
    implements AsyncPageFetcher<ListSpacesResponse> {
        private ListSpacesResponseFetcher() {
        }

        public boolean hasNextPage(ListSpacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSpacesResponse> nextPage(ListSpacesResponse previousPage) {
            if (previousPage == null) {
                return ListSpacesPublisher.this.client.listSpaces(ListSpacesPublisher.this.firstRequest);
            }
            return ListSpacesPublisher.this.client.listSpaces((ListSpacesRequest)((Object)ListSpacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

