/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<DetectFacesRequest.Builder, DetectFacesRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .getter(getter(DetectFacesRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DetectFacesRequest::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IMAGE_FIELD, ATTRIBUTES_FIELD));

    private final Image image;

    private final List<String> attributes;

    private DetectFacesRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing base64-encoded image bytes is not supported.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing base64-encoded image bytes is not supported. </p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * An array of facial attributes you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned, but the operation takes longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes you want to be returned. This can be the default list of attributes or all
     *         attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the
     *         operation takes longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<Attribute> attributes() {
        return AttributesCopier.copyStringToEnum(attributes);
    }

    /**
     * <p>
     * An array of facial attributes you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned, but the operation takes longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial attributes you want to be returned. This can be the default list of attributes or all
     *         attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the
     *         operation takes longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public List<String> attributesAsStrings() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(attributesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectFacesRequest)) {
            return false;
        }
        DetectFacesRequest other = (DetectFacesRequest) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(attributesAsStrings(), other.attributesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectFacesRequest").add("Image", image()).add("Attributes", attributesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectFacesRequest, T> g) {
        return obj -> g.apply((DetectFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectFacesRequest> {
        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param image
         *        The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing base64-encoded image bytes is not supported. </p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Collection<String> attributes);

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(String... attributes);

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * An array of facial attributes you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param attributes
         *        An array of facial attributes you want to be returned. This can be the default list of attributes or
         *        all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Image image;

        private List<String> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectFacesRequest model) {
            super(model);
            image(model.image);
            attributesWithStrings(model.attributes);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Collection<String> getAttributesAsStrings() {
            return attributes;
        }

        @Override
        public final Builder attributesWithStrings(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesWithStrings(String... attributes) {
            attributesWithStrings(Arrays.asList(attributes));
            return this;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copyEnumToString(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributesWithStrings(Collection<String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectFacesRequest build() {
            return new DetectFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
