/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing both the face metadata (stored in the backend database), and facial attributes that are detected
 * but aren't stored in the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaceRecord implements SdkPojo, Serializable, ToCopyableBuilder<FaceRecord.Builder, FaceRecord> {
    private static final SdkField<Face> FACE_FIELD = SdkField.<Face> builder(MarshallingType.SDK_POJO)
            .getter(getter(FaceRecord::face)).setter(setter(Builder::face)).constructor(Face::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final SdkField<FaceDetail> FACE_DETAIL_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(FaceRecord::faceDetail)).setter(setter(Builder::faceDetail)).constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FACE_FIELD, FACE_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Face face;

    private final FaceDetail faceDetail;

    private FaceRecord(BuilderImpl builder) {
        this.face = builder.face;
        this.faceDetail = builder.faceDetail;
    }

    /**
     * <p>
     * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image
     * ID that you assigned.
     * </p>
     * 
     * @return Describes the face properties such as the bounding box, face ID, image ID of the input image, and
     *         external image ID that you assigned.
     */
    public Face face() {
        return face;
    }

    /**
     * <p>
     * Structure containing attributes of the face that the algorithm detected.
     * </p>
     * 
     * @return Structure containing attributes of the face that the algorithm detected.
     */
    public FaceDetail faceDetail() {
        return faceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(face());
        hashCode = 31 * hashCode + Objects.hashCode(faceDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceRecord)) {
            return false;
        }
        FaceRecord other = (FaceRecord) obj;
        return Objects.equals(face(), other.face()) && Objects.equals(faceDetail(), other.faceDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FaceRecord").add("Face", face()).add("FaceDetail", faceDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        case "FaceDetail":
            return Optional.ofNullable(clazz.cast(faceDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceRecord, T> g) {
        return obj -> g.apply((FaceRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaceRecord> {
        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external
         * image ID that you assigned.
         * </p>
         * 
         * @param face
         *        Describes the face properties such as the bounding box, face ID, image ID of the input image, and
         *        external image ID that you assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(Face face);

        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external
         * image ID that you assigned.
         * </p>
         * This is a convenience that creates an instance of the {@link Face.Builder} avoiding the need to create one
         * manually via {@link Face#builder()}.
         *
         * When the {@link Consumer} completes, {@link Face.Builder#build()} is called immediately and its result is
         * passed to {@link #face(Face)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link Face.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(Face)
         */
        default Builder face(Consumer<Face.Builder> face) {
            return face(Face.builder().applyMutation(face).build());
        }

        /**
         * <p>
         * Structure containing attributes of the face that the algorithm detected.
         * </p>
         * 
         * @param faceDetail
         *        Structure containing attributes of the face that the algorithm detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetail(FaceDetail faceDetail);

        /**
         * <p>
         * Structure containing attributes of the face that the algorithm detected.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #faceDetail(FaceDetail)}.
         * 
         * @param faceDetail
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceDetail(FaceDetail)
         */
        default Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return faceDetail(FaceDetail.builder().applyMutation(faceDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Face face;

        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceRecord model) {
            face(model.face);
            faceDetail(model.faceDetail);
        }

        public final Face.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final FaceDetail.Builder getFaceDetail() {
            return faceDetail != null ? faceDetail.toBuilder() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        @Override
        public FaceRecord build() {
            return new FaceRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
