/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;

public class GetContentModerationPublisher
implements SdkPublisher<GetContentModerationResponse> {
    private final RekognitionAsyncClient client;
    private final GetContentModerationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetContentModerationPublisher(RekognitionAsyncClient client, GetContentModerationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetContentModerationPublisher(RekognitionAsyncClient client, GetContentModerationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetContentModerationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetContentModerationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetContentModerationPublisher resume(GetContentModerationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetContentModerationPublisher(this.client, (GetContentModerationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetContentModerationPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetContentModerationResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetContentModerationResponseFetcher
    implements AsyncPageFetcher<GetContentModerationResponse> {
        private GetContentModerationResponseFetcher() {
        }

        public boolean hasNextPage(GetContentModerationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetContentModerationResponse> nextPage(GetContentModerationResponse previousPage) {
            if (previousPage == null) {
                return GetContentModerationPublisher.this.client.getContentModeration(GetContentModerationPublisher.this.firstRequest);
            }
            return GetContentModerationPublisher.this.client.getContentModeration((GetContentModerationRequest)((Object)GetContentModerationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

