/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a label detected in a video analysis request and the time the label was detected in the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelDetection implements SdkPojo, Serializable, ToCopyableBuilder<LabelDetection.Builder, LabelDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(LabelDetection::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Label> LABEL_FIELD = SdkField.<Label> builder(MarshallingType.SDK_POJO)
            .getter(getter(LabelDetection::label)).setter(setter(Builder::label)).constructor(Label::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final Label label;

    private LabelDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.label = builder.label;
    }

    /**
     * <p>
     * Time, in milliseconds from the start of the video, that the label was detected.
     * </p>
     * 
     * @return Time, in milliseconds from the start of the video, that the label was detected.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about the detected label.
     * </p>
     * 
     * @return Details about the detected label.
     */
    public Label label() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelDetection)) {
            return false;
        }
        LabelDetection other = (LabelDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(label(), other.label());
    }

    @Override
    public String toString() {
        return ToString.builder("LabelDetection").add("Timestamp", timestamp()).add("Label", label()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelDetection, T> g) {
        return obj -> g.apply((LabelDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelDetection> {
        /**
         * <p>
         * Time, in milliseconds from the start of the video, that the label was detected.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the start of the video, that the label was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * 
         * @param label
         *        Details about the detected label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Label label);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * This is a convenience that creates an instance of the {@link Label.Builder} avoiding the need to create one
         * manually via {@link Label#builder()}.
         *
         * When the {@link Consumer} completes, {@link Label.Builder#build()} is called immediately and its result is
         * passed to {@link #label(Label)}.
         * 
         * @param label
         *        a consumer that will call methods on {@link Label.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(Label)
         */
        default Builder label(Consumer<Label.Builder> label) {
            return label(Label.builder().applyMutation(label).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private Label label;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelDetection model) {
            timestamp(model.timestamp);
            label(model.label);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final Label.Builder getLabel() {
            return label != null ? label.toBuilder() : null;
        }

        @Override
        public final Builder label(Label label) {
            this.label = label;
            return this;
        }

        public final void setLabel(Label.BuilderImpl label) {
            this.label = label != null ? label.build() : null;
        }

        @Override
        public LabelDetection build() {
            return new LabelDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
