/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing the estimated age range, in years, for a face.
 * </p>
 * <p>
 * Amazon Rekognition estimates an age range for faces detected in the input image. Estimated age ranges can overlap. A
 * face of a 5-year-old might have an estimated range of 4-6, while the face of a 6-year-old might have an estimated
 * range of 4-8.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgeRange implements SdkPojo, Serializable, ToCopyableBuilder<AgeRange.Builder, AgeRange> {
    private static final SdkField<Integer> LOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AgeRange::low)).setter(setter(Builder::low))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Low").build()).build();

    private static final SdkField<Integer> HIGH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AgeRange::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("High").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOW_FIELD, HIGH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer low;

    private final Integer high;

    private AgeRange(BuilderImpl builder) {
        this.low = builder.low;
        this.high = builder.high;
    }

    /**
     * <p>
     * The lowest estimated age.
     * </p>
     * 
     * @return The lowest estimated age.
     */
    public Integer low() {
        return low;
    }

    /**
     * <p>
     * The highest estimated age.
     * </p>
     * 
     * @return The highest estimated age.
     */
    public Integer high() {
        return high;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(low());
        hashCode = 31 * hashCode + Objects.hashCode(high());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgeRange)) {
            return false;
        }
        AgeRange other = (AgeRange) obj;
        return Objects.equals(low(), other.low()) && Objects.equals(high(), other.high());
    }

    @Override
    public String toString() {
        return ToString.builder("AgeRange").add("Low", low()).add("High", high()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Low":
            return Optional.ofNullable(clazz.cast(low()));
        case "High":
            return Optional.ofNullable(clazz.cast(high()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgeRange, T> g) {
        return obj -> g.apply((AgeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgeRange> {
        /**
         * <p>
         * The lowest estimated age.
         * </p>
         * 
         * @param low
         *        The lowest estimated age.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Integer low);

        /**
         * <p>
         * The highest estimated age.
         * </p>
         * 
         * @param high
         *        The highest estimated age.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Integer high);
    }

    static final class BuilderImpl implements Builder {
        private Integer low;

        private Integer high;

        private BuilderImpl() {
        }

        private BuilderImpl(AgeRange model) {
            low(model.low);
            high(model.high);
        }

        public final Integer getLow() {
            return low;
        }

        @Override
        public final Builder low(Integer low) {
            this.low = low;
            return this;
        }

        public final void setLow(Integer low) {
            this.low = low;
        }

        public final Integer getHigh() {
            return high;
        }

        @Override
        public final Builder high(Integer high) {
            this.high = high;
            return this;
        }

        public final void setHigh(Integer high) {
            this.high = high;
        }

        @Override
        public AgeRange build() {
            return new AgeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
