/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID
 * that you assigned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Face implements SdkPojo, Serializable, ToCopyableBuilder<Face.Builder, Face> {
    private static final SdkField<String> FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FaceId")
            .getter(getter(Face::faceId)).setter(setter(Builder::faceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(Face::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(Face::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> EXTERNAL_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalImageId").getter(getter(Face::externalImageId)).setter(setter(Builder::externalImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalImageId").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(Face::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<String> INDEX_FACES_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexFacesModelVersion").getter(getter(Face::indexFacesModelVersion))
            .setter(setter(Builder::indexFacesModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFacesModelVersion").build())
            .build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(Face::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_ID_FIELD,
            BOUNDING_BOX_FIELD, IMAGE_ID_FIELD, EXTERNAL_IMAGE_ID_FIELD, CONFIDENCE_FIELD, INDEX_FACES_MODEL_VERSION_FIELD,
            USER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String faceId;

    private final BoundingBox boundingBox;

    private final String imageId;

    private final String externalImageId;

    private final Float confidence;

    private final String indexFacesModelVersion;

    private final String userId;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
        this.indexFacesModelVersion = builder.indexFacesModelVersion;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the face.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the face.
     */
    public final String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the input image.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the input image.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Identifier that you assign to all the faces in the input image.
     * </p>
     * 
     * @return Identifier that you assign to all the faces in the input image.
     */
    public final String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * Confidence level that the bounding box contains a face (and not a different object such as a tree).
     * </p>
     * 
     * @return Confidence level that the bounding box contains a face (and not a different object such as a tree).
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The version of the face detect and storage model that was used when indexing the face vector.
     * </p>
     * 
     * @return The version of the face detect and storage model that was used when indexing the face vector.
     */
    public final String indexFacesModelVersion() {
        return indexFacesModelVersion;
    }

    /**
     * <p>
     * Unique identifier assigned to the user.
     * </p>
     * 
     * @return Unique identifier assigned to the user.
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceId());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(indexFacesModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face) obj;
        return Objects.equals(faceId(), other.faceId()) && Objects.equals(boundingBox(), other.boundingBox())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(externalImageId(), other.externalImageId())
                && Objects.equals(confidence(), other.confidence())
                && Objects.equals(indexFacesModelVersion(), other.indexFacesModelVersion())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Face").add("FaceId", faceId()).add("BoundingBox", boundingBox()).add("ImageId", imageId())
                .add("ExternalImageId", externalImageId()).add("Confidence", confidence())
                .add("IndexFacesModelVersion", indexFacesModelVersion()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceId":
            return Optional.ofNullable(clazz.cast(faceId()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ExternalImageId":
            return Optional.ofNullable(clazz.cast(externalImageId()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "IndexFacesModelVersion":
            return Optional.ofNullable(clazz.cast(indexFacesModelVersion()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FaceId", FACE_ID_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ExternalImageId", EXTERNAL_IMAGE_ID_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("IndexFacesModelVersion", INDEX_FACES_MODEL_VERSION_FIELD);
        map.put("UserId", USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Face, T> g) {
        return obj -> g.apply((Face) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Face> {
        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the face.
         * </p>
         * 
         * @param faceId
         *        Unique identifier that Amazon Rekognition assigns to the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoundingBox.Builder} avoiding the need to
         * create one manually via {@link BoundingBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the input image.
         * </p>
         * 
         * @param imageId
         *        Unique identifier that Amazon Rekognition assigns to the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Identifier that you assign to all the faces in the input image.
         * </p>
         * 
         * @param externalImageId
         *        Identifier that you assign to all the faces in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * </p>
         * 
         * @param confidence
         *        Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The version of the face detect and storage model that was used when indexing the face vector.
         * </p>
         * 
         * @param indexFacesModelVersion
         *        The version of the face detect and storage model that was used when indexing the face vector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFacesModelVersion(String indexFacesModelVersion);

        /**
         * <p>
         * Unique identifier assigned to the user.
         * </p>
         * 
         * @param userId
         *        Unique identifier assigned to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String faceId;

        private BoundingBox boundingBox;

        private String imageId;

        private String externalImageId;

        private Float confidence;

        private String indexFacesModelVersion;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            faceId(model.faceId);
            boundingBox(model.boundingBox);
            imageId(model.imageId);
            externalImageId(model.externalImageId);
            confidence(model.confidence);
            indexFacesModelVersion(model.indexFacesModelVersion);
            userId(model.userId);
        }

        public final String getFaceId() {
            return faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getIndexFacesModelVersion() {
            return indexFacesModelVersion;
        }

        public final void setIndexFacesModelVersion(String indexFacesModelVersion) {
            this.indexFacesModelVersion = indexFacesModelVersion;
        }

        @Override
        public final Builder indexFacesModelVersion(String indexFacesModelVersion) {
            this.indexFacesModelVersion = indexFacesModelVersion;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public Face build() {
            return new Face(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
