/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisInput;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisOperationsConfig;
import software.amazon.awssdk.services.rekognition.model.MediaAnalysisOutputConfig;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMediaAnalysisJobRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, StartMediaAnalysisJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::clientRequestToken)).setter(StartMediaAnalysisJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::jobName)).setter(StartMediaAnalysisJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<MediaAnalysisOperationsConfig> OPERATIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationsConfig").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::operationsConfig)).setter(StartMediaAnalysisJobRequest.setter(Builder::operationsConfig)).constructor(MediaAnalysisOperationsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsConfig").build()}).build();
    private static final SdkField<MediaAnalysisInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::input)).setter(StartMediaAnalysisJobRequest.setter(Builder::input)).constructor(MediaAnalysisInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<MediaAnalysisOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::outputConfig)).setter(StartMediaAnalysisJobRequest.setter(Builder::outputConfig)).constructor(MediaAnalysisOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StartMediaAnalysisJobRequest.getter(StartMediaAnalysisJobRequest::kmsKeyId)).setter(StartMediaAnalysisJobRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, JOB_NAME_FIELD, OPERATIONS_CONFIG_FIELD, INPUT_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMediaAnalysisJobRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String jobName;
    private final MediaAnalysisOperationsConfig operationsConfig;
    private final MediaAnalysisInput input;
    private final MediaAnalysisOutputConfig outputConfig;
    private final String kmsKeyId;

    private StartMediaAnalysisJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.jobName = builder.jobName;
        this.operationsConfig = builder.operationsConfig;
        this.input = builder.input;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final MediaAnalysisOperationsConfig operationsConfig() {
        return this.operationsConfig;
    }

    public final MediaAnalysisInput input() {
        return this.input;
    }

    public final MediaAnalysisOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMediaAnalysisJobRequest)) {
            return false;
        }
        StartMediaAnalysisJobRequest other = (StartMediaAnalysisJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.operationsConfig(), other.operationsConfig()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"StartMediaAnalysisJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("JobName", (Object)this.jobName()).add("OperationsConfig", (Object)this.operationsConfig()).add("Input", (Object)this.input()).add("OutputConfig", (Object)this.outputConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "OperationsConfig": {
                return Optional.ofNullable(clazz.cast(this.operationsConfig()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("OperationsConfig", OPERATIONS_CONFIG_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMediaAnalysisJobRequest, T> g) {
        return obj -> g.apply((StartMediaAnalysisJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String jobName;
        private MediaAnalysisOperationsConfig operationsConfig;
        private MediaAnalysisInput input;
        private MediaAnalysisOutputConfig outputConfig;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMediaAnalysisJobRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.jobName(model.jobName);
            this.operationsConfig(model.operationsConfig);
            this.input(model.input);
            this.outputConfig(model.outputConfig);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final MediaAnalysisOperationsConfig.Builder getOperationsConfig() {
            return this.operationsConfig != null ? this.operationsConfig.toBuilder() : null;
        }

        public final void setOperationsConfig(MediaAnalysisOperationsConfig.BuilderImpl operationsConfig) {
            this.operationsConfig = operationsConfig != null ? operationsConfig.build() : null;
        }

        @Override
        public final Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig) {
            this.operationsConfig = operationsConfig;
            return this;
        }

        public final MediaAnalysisInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(MediaAnalysisInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(MediaAnalysisInput input) {
            this.input = input;
            return this;
        }

        public final MediaAnalysisOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(MediaAnalysisOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(MediaAnalysisOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMediaAnalysisJobRequest build() {
            return new StartMediaAnalysisJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMediaAnalysisJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder jobName(String var1);

        public Builder operationsConfig(MediaAnalysisOperationsConfig var1);

        default public Builder operationsConfig(Consumer<MediaAnalysisOperationsConfig.Builder> operationsConfig) {
            return this.operationsConfig((MediaAnalysisOperationsConfig)((MediaAnalysisOperationsConfig.Builder)MediaAnalysisOperationsConfig.builder().applyMutation(operationsConfig)).build());
        }

        public Builder input(MediaAnalysisInput var1);

        default public Builder input(Consumer<MediaAnalysisInput.Builder> input) {
            return this.input((MediaAnalysisInput)((MediaAnalysisInput.Builder)MediaAnalysisInput.builder().applyMutation(input)).build());
        }

        public Builder outputConfig(MediaAnalysisOutputConfig var1);

        default public Builder outputConfig(Consumer<MediaAnalysisOutputConfig.Builder> outputConfig) {
            return this.outputConfig((MediaAnalysisOutputConfig)((MediaAnalysisOutputConfig.Builder)MediaAnalysisOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

