/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.DatasetStatus;
import software.amazon.awssdk.services.rekognition.model.DatasetStatusMessageCode;
import software.amazon.awssdk.services.rekognition.model.DatasetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetMetadata> {
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(DatasetMetadata.getter(DatasetMetadata::creationTimestamp)).setter(DatasetMetadata.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(DatasetMetadata.getter(DatasetMetadata::datasetTypeAsString)).setter(DatasetMetadata.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DatasetMetadata.getter(DatasetMetadata::datasetArn)).setter(DatasetMetadata.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatasetMetadata.getter(DatasetMetadata::statusAsString)).setter(DatasetMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DatasetMetadata.getter(DatasetMetadata::statusMessage)).setter(DatasetMetadata.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessageCode").getter(DatasetMetadata.getter(DatasetMetadata::statusMessageCodeAsString)).setter(DatasetMetadata.setter(Builder::statusMessageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIMESTAMP_FIELD, DATASET_TYPE_FIELD, DATASET_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STATUS_MESSAGE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTimestamp;
    private final String datasetType;
    private final String datasetArn;
    private final String status;
    private final String statusMessage;
    private final String statusMessageCode;

    private DatasetMetadata(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.datasetType = builder.datasetType;
        this.datasetArn = builder.datasetArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.statusMessageCode = builder.statusMessageCode;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final DatasetType datasetType() {
        return DatasetType.fromValue(this.datasetType);
    }

    public final String datasetTypeAsString() {
        return this.datasetType;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final DatasetStatusMessageCode statusMessageCode() {
        return DatasetStatusMessageCode.fromValue(this.statusMessageCode);
    }

    public final String statusMessageCodeAsString() {
        return this.statusMessageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata)obj;
        return Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.datasetTypeAsString(), other.datasetTypeAsString()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusMessageCodeAsString(), other.statusMessageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetMetadata").add("CreationTimestamp", (Object)this.creationTimestamp()).add("DatasetType", (Object)this.datasetTypeAsString()).add("DatasetArn", (Object)this.datasetArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StatusMessageCode", (Object)this.statusMessageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetTypeAsString()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "StatusMessageCode": {
                return Optional.ofNullable(clazz.cast(this.statusMessageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("DatasetType", DATASET_TYPE_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("StatusMessageCode", STATUS_MESSAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetMetadata, T> g) {
        return obj -> g.apply((DatasetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTimestamp;
        private String datasetType;
        private String datasetArn;
        private String status;
        private String statusMessage;
        private String statusMessageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetMetadata model) {
            this.creationTimestamp(model.creationTimestamp);
            this.datasetType(model.datasetType);
            this.datasetArn(model.datasetArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.statusMessageCode(model.statusMessageCode);
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatusMessageCode() {
            return this.statusMessageCode;
        }

        public final void setStatusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
        }

        @Override
        public final Builder statusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
            return this;
        }

        @Override
        public final Builder statusMessageCode(DatasetStatusMessageCode statusMessageCode) {
            this.statusMessageCode(statusMessageCode == null ? null : statusMessageCode.toString());
            return this;
        }

        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetMetadata> {
        public Builder creationTimestamp(Instant var1);

        public Builder datasetType(String var1);

        public Builder datasetType(DatasetType var1);

        public Builder datasetArn(String var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder statusMessage(String var1);

        public Builder statusMessageCode(String var1);

        public Builder statusMessageCode(DatasetStatusMessageCode var1);
    }
}

