/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUsersByImageResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchUsersByImageResponse.Builder, SearchUsersByImageResponse> {
    private static final SdkField<List<UserMatch>> USER_MATCHES_FIELD = SdkField
            .<List<UserMatch>> builder(MarshallingType.LIST)
            .memberName("UserMatches")
            .getter(getter(SearchUsersByImageResponse::userMatches))
            .setter(setter(Builder::userMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceModelVersion").getter(getter(SearchUsersByImageResponse::faceModelVersion))
            .setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final SdkField<SearchedFaceDetails> SEARCHED_FACE_FIELD = SdkField
            .<SearchedFaceDetails> builder(MarshallingType.SDK_POJO).memberName("SearchedFace")
            .getter(getter(SearchUsersByImageResponse::searchedFace)).setter(setter(Builder::searchedFace))
            .constructor(SearchedFaceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFace").build()).build();

    private static final SdkField<List<UnsearchedFace>> UNSEARCHED_FACES_FIELD = SdkField
            .<List<UnsearchedFace>> builder(MarshallingType.LIST)
            .memberName("UnsearchedFaces")
            .getter(getter(SearchUsersByImageResponse::unsearchedFaces))
            .setter(setter(Builder::unsearchedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsearchedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnsearchedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsearchedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MATCHES_FIELD,
            FACE_MODEL_VERSION_FIELD, SEARCHED_FACE_FIELD, UNSEARCHED_FACES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserMatch> userMatches;

    private final String faceModelVersion;

    private final SearchedFaceDetails searchedFace;

    private final List<UnsearchedFace> unsearchedFaces;

    private SearchUsersByImageResponse(BuilderImpl builder) {
        super(builder);
        this.userMatches = builder.userMatches;
        this.faceModelVersion = builder.faceModelVersion;
        this.searchedFace = builder.searchedFace;
        this.unsearchedFaces = builder.unsearchedFaces;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMatches() {
        return userMatches != null && !(userMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of UserID objects that matched the input face, along with the confidence in the match. The returned
     * structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse action is successful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMatches} method.
     * </p>
     * 
     * @return An array of UserID objects that matched the input face, along with the confidence in the match. The
     *         returned structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse
     *         action is successful.
     */
    public final List<UserMatch> userMatches() {
        return userMatches;
    }

    /**
     * <p>
     * Version number of the face detection model associated with the input collection CollectionId.
     * </p>
     * 
     * @return Version number of the face detection model associated with the input collection CollectionId.
     */
    public final String faceModelVersion() {
        return faceModelVersion;
    }

    /**
     * <p>
     * A list of FaceDetail objects containing the BoundingBox for the largest face in image, as well as the confidence
     * in the bounding box, that was searched for matches. If no valid face is detected in the image the response will
     * contain no SearchedFace object.
     * </p>
     * 
     * @return A list of FaceDetail objects containing the BoundingBox for the largest face in image, as well as the
     *         confidence in the bounding box, that was searched for matches. If no valid face is detected in the image
     *         the response will contain no SearchedFace object.
     */
    public final SearchedFaceDetails searchedFace() {
        return searchedFace;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsearchedFaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsearchedFaces() {
        return unsearchedFaces != null && !(unsearchedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of UnsearchedFace objects. Contains the face details infered from the specified image but not used for
     * search. Contains reasons that describe why a face wasn't used for Search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsearchedFaces} method.
     * </p>
     * 
     * @return List of UnsearchedFace objects. Contains the face details infered from the specified image but not used
     *         for search. Contains reasons that describe why a face wasn't used for Search.
     */
    public final List<UnsearchedFace> unsearchedFaces() {
        return unsearchedFaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMatches() ? userMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(searchedFace());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsearchedFaces() ? unsearchedFaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersByImageResponse)) {
            return false;
        }
        SearchUsersByImageResponse other = (SearchUsersByImageResponse) obj;
        return hasUserMatches() == other.hasUserMatches() && Objects.equals(userMatches(), other.userMatches())
                && Objects.equals(faceModelVersion(), other.faceModelVersion())
                && Objects.equals(searchedFace(), other.searchedFace()) && hasUnsearchedFaces() == other.hasUnsearchedFaces()
                && Objects.equals(unsearchedFaces(), other.unsearchedFaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUsersByImageResponse").add("UserMatches", hasUserMatches() ? userMatches() : null)
                .add("FaceModelVersion", faceModelVersion()).add("SearchedFace", searchedFace())
                .add("UnsearchedFaces", hasUnsearchedFaces() ? unsearchedFaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserMatches":
            return Optional.ofNullable(clazz.cast(userMatches()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        case "SearchedFace":
            return Optional.ofNullable(clazz.cast(searchedFace()));
        case "UnsearchedFaces":
            return Optional.ofNullable(clazz.cast(unsearchedFaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserMatches", USER_MATCHES_FIELD);
        map.put("FaceModelVersion", FACE_MODEL_VERSION_FIELD);
        map.put("SearchedFace", SEARCHED_FACE_FIELD);
        map.put("UnsearchedFaces", UNSEARCHED_FACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersByImageResponse, T> g) {
        return obj -> g.apply((SearchUsersByImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchUsersByImageResponse> {
        /**
         * <p>
         * An array of UserID objects that matched the input face, along with the confidence in the match. The returned
         * structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse action is
         * successful.
         * </p>
         * 
         * @param userMatches
         *        An array of UserID objects that matched the input face, along with the confidence in the match. The
         *        returned structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse
         *        action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatches(Collection<UserMatch> userMatches);

        /**
         * <p>
         * An array of UserID objects that matched the input face, along with the confidence in the match. The returned
         * structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse action is
         * successful.
         * </p>
         * 
         * @param userMatches
         *        An array of UserID objects that matched the input face, along with the confidence in the match. The
         *        returned structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse
         *        action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatches(UserMatch... userMatches);

        /**
         * <p>
         * An array of UserID objects that matched the input face, along with the confidence in the match. The returned
         * structure will be empty if there are no matches. Returned if the SearchUsersByImageResponse action is
         * successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.UserMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder#build()} is called immediately and
         * its result is passed to {@link #userMatches(List<UserMatch>)}.
         * 
         * @param userMatches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userMatches(java.util.Collection<UserMatch>)
         */
        Builder userMatches(Consumer<UserMatch.Builder>... userMatches);

        /**
         * <p>
         * Version number of the face detection model associated with the input collection CollectionId.
         * </p>
         * 
         * @param faceModelVersion
         *        Version number of the face detection model associated with the input collection CollectionId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);

        /**
         * <p>
         * A list of FaceDetail objects containing the BoundingBox for the largest face in image, as well as the
         * confidence in the bounding box, that was searched for matches. If no valid face is detected in the image the
         * response will contain no SearchedFace object.
         * </p>
         * 
         * @param searchedFace
         *        A list of FaceDetail objects containing the BoundingBox for the largest face in image, as well as the
         *        confidence in the bounding box, that was searched for matches. If no valid face is detected in the
         *        image the response will contain no SearchedFace object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFace(SearchedFaceDetails searchedFace);

        /**
         * <p>
         * A list of FaceDetail objects containing the BoundingBox for the largest face in image, as well as the
         * confidence in the bounding box, that was searched for matches. If no valid face is detected in the image the
         * response will contain no SearchedFace object.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchedFaceDetails.Builder} avoiding the
         * need to create one manually via {@link SearchedFaceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchedFaceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #searchedFace(SearchedFaceDetails)}.
         * 
         * @param searchedFace
         *        a consumer that will call methods on {@link SearchedFaceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedFace(SearchedFaceDetails)
         */
        default Builder searchedFace(Consumer<SearchedFaceDetails.Builder> searchedFace) {
            return searchedFace(SearchedFaceDetails.builder().applyMutation(searchedFace).build());
        }

        /**
         * <p>
         * List of UnsearchedFace objects. Contains the face details infered from the specified image but not used for
         * search. Contains reasons that describe why a face wasn't used for Search.
         * </p>
         * 
         * @param unsearchedFaces
         *        List of UnsearchedFace objects. Contains the face details infered from the specified image but not
         *        used for search. Contains reasons that describe why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsearchedFaces(Collection<UnsearchedFace> unsearchedFaces);

        /**
         * <p>
         * List of UnsearchedFace objects. Contains the face details infered from the specified image but not used for
         * search. Contains reasons that describe why a face wasn't used for Search.
         * </p>
         * 
         * @param unsearchedFaces
         *        List of UnsearchedFace objects. Contains the face details infered from the specified image but not
         *        used for search. Contains reasons that describe why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsearchedFaces(UnsearchedFace... unsearchedFaces);

        /**
         * <p>
         * List of UnsearchedFace objects. Contains the face details infered from the specified image but not used for
         * search. Contains reasons that describe why a face wasn't used for Search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UnsearchedFace.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.UnsearchedFace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UnsearchedFace.Builder#build()} is called
         * immediately and its result is passed to {@link #unsearchedFaces(List<UnsearchedFace>)}.
         * 
         * @param unsearchedFaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UnsearchedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsearchedFaces(java.util.Collection<UnsearchedFace>)
         */
        Builder unsearchedFaces(Consumer<UnsearchedFace.Builder>... unsearchedFaces);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<UserMatch> userMatches = DefaultSdkAutoConstructList.getInstance();

        private String faceModelVersion;

        private SearchedFaceDetails searchedFace;

        private List<UnsearchedFace> unsearchedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersByImageResponse model) {
            super(model);
            userMatches(model.userMatches);
            faceModelVersion(model.faceModelVersion);
            searchedFace(model.searchedFace);
            unsearchedFaces(model.unsearchedFaces);
        }

        public final List<UserMatch.Builder> getUserMatches() {
            List<UserMatch.Builder> result = UserMatchListCopier.copyToBuilder(this.userMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserMatches(Collection<UserMatch.BuilderImpl> userMatches) {
            this.userMatches = UserMatchListCopier.copyFromBuilder(userMatches);
        }

        @Override
        public final Builder userMatches(Collection<UserMatch> userMatches) {
            this.userMatches = UserMatchListCopier.copy(userMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(UserMatch... userMatches) {
            userMatches(Arrays.asList(userMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(Consumer<UserMatch.Builder>... userMatches) {
            userMatches(Stream.of(userMatches).map(c -> UserMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final SearchedFaceDetails.Builder getSearchedFace() {
            return searchedFace != null ? searchedFace.toBuilder() : null;
        }

        public final void setSearchedFace(SearchedFaceDetails.BuilderImpl searchedFace) {
            this.searchedFace = searchedFace != null ? searchedFace.build() : null;
        }

        @Override
        public final Builder searchedFace(SearchedFaceDetails searchedFace) {
            this.searchedFace = searchedFace;
            return this;
        }

        public final List<UnsearchedFace.Builder> getUnsearchedFaces() {
            List<UnsearchedFace.Builder> result = UnsearchedFacesListCopier.copyToBuilder(this.unsearchedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsearchedFaces(Collection<UnsearchedFace.BuilderImpl> unsearchedFaces) {
            this.unsearchedFaces = UnsearchedFacesListCopier.copyFromBuilder(unsearchedFaces);
        }

        @Override
        public final Builder unsearchedFaces(Collection<UnsearchedFace> unsearchedFaces) {
            this.unsearchedFaces = UnsearchedFacesListCopier.copy(unsearchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsearchedFaces(UnsearchedFace... unsearchedFaces) {
            unsearchedFaces(Arrays.asList(unsearchedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsearchedFaces(Consumer<UnsearchedFace.Builder>... unsearchedFaces) {
            unsearchedFaces(Stream.of(unsearchedFaces).map(c -> UnsearchedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchUsersByImageResponse build() {
            return new SearchUsersByImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
