/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.waiters.RekognitionWaiter;
import software.amazon.awssdk.services.rekognition.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRekognitionWaiter
implements RekognitionWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final RekognitionClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeProjectVersionsResponse> projectVersionTrainingCompletedWaiter;
    private final Waiter<DescribeProjectVersionsResponse> projectVersionRunningWaiter;

    private DefaultRekognitionWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RekognitionClient)RekognitionClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.projectVersionTrainingCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeProjectVersionsResponse.class).acceptors(DefaultRekognitionWaiter.projectVersionTrainingCompletedWaiterAcceptors())).overrideConfiguration(DefaultRekognitionWaiter.projectVersionTrainingCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.projectVersionRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeProjectVersionsResponse.class).acceptors(DefaultRekognitionWaiter.projectVersionRunningWaiterAcceptors())).overrideConfiguration(DefaultRekognitionWaiter.projectVersionRunningWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeProjectVersionsResponse> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        return this.projectVersionRunningWaiter.run(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeProjectVersionsResponse> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.projectVersionRunningWaiter.run(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)), DefaultRekognitionWaiter.projectVersionRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeProjectVersionsResponse> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        return this.projectVersionTrainingCompletedWaiter.run(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeProjectVersionsResponse> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.projectVersionTrainingCompletedWaiter.run(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)), DefaultRekognitionWaiter.projectVersionTrainingCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeProjectVersionsResponse>> projectVersionTrainingCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "TRAINING_COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "TRAINING_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ProjectVersionDescriptions[].Status=TRAINING_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeProjectVersionsResponse>> projectVersionRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ProjectVersionDescriptions[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration projectVersionTrainingCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration projectVersionRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RekognitionWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RekognitionRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RekognitionRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RekognitionWaiter.Builder {
        private RekognitionClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RekognitionWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RekognitionWaiter.Builder client(RekognitionClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RekognitionWaiter build() {
            return new DefaultRekognitionWaiter(this);
        }
    }
}

