/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Feature specific configuration for the training job. Configuration provided for the job must match the feature type
 * parameter associated with project. If configuration and feature type do not match an InvalidParameterException is
 * returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomizationFeatureConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomizationFeatureConfig.Builder, CustomizationFeatureConfig> {
    private static final SdkField<CustomizationFeatureContentModerationConfig> CONTENT_MODERATION_FIELD = SdkField
            .<CustomizationFeatureContentModerationConfig> builder(MarshallingType.SDK_POJO).memberName("ContentModeration")
            .getter(getter(CustomizationFeatureConfig::contentModeration)).setter(setter(Builder::contentModeration))
            .constructor(CustomizationFeatureContentModerationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentModeration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_MODERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomizationFeatureContentModerationConfig contentModeration;

    private CustomizationFeatureConfig(BuilderImpl builder) {
        this.contentModeration = builder.contentModeration;
    }

    /**
     * <p>
     * Configuration options for Custom Moderation training.
     * </p>
     * 
     * @return Configuration options for Custom Moderation training.
     */
    public final CustomizationFeatureContentModerationConfig contentModeration() {
        return contentModeration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentModeration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizationFeatureConfig)) {
            return false;
        }
        CustomizationFeatureConfig other = (CustomizationFeatureConfig) obj;
        return Objects.equals(contentModeration(), other.contentModeration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomizationFeatureConfig").add("ContentModeration", contentModeration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentModeration":
            return Optional.ofNullable(clazz.cast(contentModeration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomizationFeatureConfig, T> g) {
        return obj -> g.apply((CustomizationFeatureConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomizationFeatureConfig> {
        /**
         * <p>
         * Configuration options for Custom Moderation training.
         * </p>
         * 
         * @param contentModeration
         *        Configuration options for Custom Moderation training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentModeration(CustomizationFeatureContentModerationConfig contentModeration);

        /**
         * <p>
         * Configuration options for Custom Moderation training.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomizationFeatureContentModerationConfig.Builder} avoiding the need to create one manually via
         * {@link CustomizationFeatureContentModerationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizationFeatureContentModerationConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #contentModeration(CustomizationFeatureContentModerationConfig)}.
         * 
         * @param contentModeration
         *        a consumer that will call methods on {@link CustomizationFeatureContentModerationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentModeration(CustomizationFeatureContentModerationConfig)
         */
        default Builder contentModeration(Consumer<CustomizationFeatureContentModerationConfig.Builder> contentModeration) {
            return contentModeration(CustomizationFeatureContentModerationConfig.builder().applyMutation(contentModeration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomizationFeatureContentModerationConfig contentModeration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizationFeatureConfig model) {
            contentModeration(model.contentModeration);
        }

        public final CustomizationFeatureContentModerationConfig.Builder getContentModeration() {
            return contentModeration != null ? contentModeration.toBuilder() : null;
        }

        public final void setContentModeration(CustomizationFeatureContentModerationConfig.BuilderImpl contentModeration) {
            this.contentModeration = contentModeration != null ? contentModeration.build() : null;
        }

        @Override
        public final Builder contentModeration(CustomizationFeatureContentModerationConfig contentModeration) {
            this.contentModeration = contentModeration;
            return this;
        }

        @Override
        public CustomizationFeatureConfig build() {
            return new CustomizationFeatureConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
