/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMediaAnalysisJobsResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListMediaAnalysisJobsResponse.Builder, ListMediaAnalysisJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMediaAnalysisJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MediaAnalysisJobDescription>> MEDIA_ANALYSIS_JOBS_FIELD = SdkField
            .<List<MediaAnalysisJobDescription>> builder(MarshallingType.LIST)
            .memberName("MediaAnalysisJobs")
            .getter(getter(ListMediaAnalysisJobsResponse::mediaAnalysisJobs))
            .setter(setter(Builder::mediaAnalysisJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaAnalysisJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaAnalysisJobDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaAnalysisJobDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MEDIA_ANALYSIS_JOBS_FIELD));

    private final String nextToken;

    private final List<MediaAnalysisJobDescription> mediaAnalysisJobs;

    private ListMediaAnalysisJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.mediaAnalysisJobs = builder.mediaAnalysisJobs;
    }

    /**
     * <p>
     * Pagination token, if the previous response was incomplete.
     * </p>
     * 
     * @return Pagination token, if the previous response was incomplete.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaAnalysisJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaAnalysisJobs() {
        return mediaAnalysisJobs != null && !(mediaAnalysisJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of all media analysis jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaAnalysisJobs} method.
     * </p>
     * 
     * @return Contains a list of all media analysis jobs.
     */
    public final List<MediaAnalysisJobDescription> mediaAnalysisJobs() {
        return mediaAnalysisJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaAnalysisJobs() ? mediaAnalysisJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMediaAnalysisJobsResponse)) {
            return false;
        }
        ListMediaAnalysisJobsResponse other = (ListMediaAnalysisJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMediaAnalysisJobs() == other.hasMediaAnalysisJobs()
                && Objects.equals(mediaAnalysisJobs(), other.mediaAnalysisJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMediaAnalysisJobsResponse").add("NextToken", nextToken())
                .add("MediaAnalysisJobs", hasMediaAnalysisJobs() ? mediaAnalysisJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MediaAnalysisJobs":
            return Optional.ofNullable(clazz.cast(mediaAnalysisJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMediaAnalysisJobsResponse, T> g) {
        return obj -> g.apply((ListMediaAnalysisJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMediaAnalysisJobsResponse> {
        /**
         * <p>
         * Pagination token, if the previous response was incomplete.
         * </p>
         * 
         * @param nextToken
         *        Pagination token, if the previous response was incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains a list of all media analysis jobs.
         * </p>
         * 
         * @param mediaAnalysisJobs
         *        Contains a list of all media analysis jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaAnalysisJobs(Collection<MediaAnalysisJobDescription> mediaAnalysisJobs);

        /**
         * <p>
         * Contains a list of all media analysis jobs.
         * </p>
         * 
         * @param mediaAnalysisJobs
         *        Contains a list of all media analysis jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaAnalysisJobs(MediaAnalysisJobDescription... mediaAnalysisJobs);

        /**
         * <p>
         * Contains a list of all media analysis jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescription.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescription.Builder#build()} is
         * called immediately and its result is passed to {@link #mediaAnalysisJobs(List<MediaAnalysisJobDescription>)}.
         * 
         * @param mediaAnalysisJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.MediaAnalysisJobDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaAnalysisJobs(java.util.Collection<MediaAnalysisJobDescription>)
         */
        Builder mediaAnalysisJobs(Consumer<MediaAnalysisJobDescription.Builder>... mediaAnalysisJobs);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MediaAnalysisJobDescription> mediaAnalysisJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMediaAnalysisJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            mediaAnalysisJobs(model.mediaAnalysisJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MediaAnalysisJobDescription.Builder> getMediaAnalysisJobs() {
            List<MediaAnalysisJobDescription.Builder> result = MediaAnalysisJobDescriptionsCopier
                    .copyToBuilder(this.mediaAnalysisJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaAnalysisJobs(Collection<MediaAnalysisJobDescription.BuilderImpl> mediaAnalysisJobs) {
            this.mediaAnalysisJobs = MediaAnalysisJobDescriptionsCopier.copyFromBuilder(mediaAnalysisJobs);
        }

        @Override
        public final Builder mediaAnalysisJobs(Collection<MediaAnalysisJobDescription> mediaAnalysisJobs) {
            this.mediaAnalysisJobs = MediaAnalysisJobDescriptionsCopier.copy(mediaAnalysisJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaAnalysisJobs(MediaAnalysisJobDescription... mediaAnalysisJobs) {
            mediaAnalysisJobs(Arrays.asList(mediaAnalysisJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaAnalysisJobs(Consumer<MediaAnalysisJobDescription.Builder>... mediaAnalysisJobs) {
            mediaAnalysisJobs(Stream.of(mediaAnalysisJobs)
                    .map(c -> MediaAnalysisJobDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMediaAnalysisJobsResponse build() {
            return new ListMediaAnalysisJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
