/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectsRequest extends RekognitionRequest implements
        ToCopyableBuilder<DescribeProjectsRequest.Builder, DescribeProjectsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeProjectsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeProjectsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> PROJECT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProjectNames")
            .getter(getter(DescribeProjectsRequest::projectNames))
            .setter(setter(Builder::projectNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(DescribeProjectsRequest::featuresAsStrings))
            .setter(setter(Builder::featuresWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, PROJECT_NAMES_FIELD, FEATURES_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> projectNames;

    private final List<String> features;

    private DescribeProjectsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.projectNames = builder.projectNames;
        this.features = builder.features;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Rekognition returns
     *         a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *         you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectNames() {
        return projectNames != null && !(projectNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response includes
     * descriptions for all the projects in your AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectNames} method.
     * </p>
     * 
     * @return A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
     *         includes descriptions for all the projects in your AWS account.
     */
    public final List<String> projectNames() {
        return projectNames;
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
     *         used as a default.
     */
    public final List<CustomizationFeature> features() {
        return CustomizationFeaturesCopier.copyStringToEnum(features);
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as a
     * default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
     *         used as a default.
     */
    public final List<String> featuresAsStrings() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectNames() ? projectNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? featuresAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectsRequest)) {
            return false;
        }
        DescribeProjectsRequest other = (DescribeProjectsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasProjectNames() == other.hasProjectNames() && Objects.equals(projectNames(), other.projectNames())
                && hasFeatures() == other.hasFeatures() && Objects.equals(featuresAsStrings(), other.featuresAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ProjectNames", hasProjectNames() ? projectNames() : null)
                .add("Features", hasFeatures() ? featuresAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ProjectNames":
            return Optional.ofNullable(clazz.cast(projectNames()));
        case "Features":
            return Optional.ofNullable(clazz.cast(featuresAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectsRequest, T> g) {
        return obj -> g.apply((DescribeProjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectsRequest> {
        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Rekognition returns a
         * pagination token in the response. You can use this pagination token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Rekognition
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
         * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value you can specify is 100.
         *        If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
         * includes descriptions for all the projects in your AWS account.
         * </p>
         * 
         * @param projectNames
         *        A list of the projects that you want Rekognition to describe. If you don't specify a value, the
         *        response includes descriptions for all the projects in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectNames(Collection<String> projectNames);

        /**
         * <p>
         * A list of the projects that you want Rekognition to describe. If you don't specify a value, the response
         * includes descriptions for all the projects in your AWS account.
         * </p>
         * 
         * @param projectNames
         *        A list of the projects that you want Rekognition to describe. If you don't specify a value, the
         *        response includes descriptions for all the projects in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectNames(String... projectNames);

        /**
         * <p>
         * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as
         * a default.
         * </p>
         * 
         * @param features
         *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
         *        used as a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(Collection<String> features);

        /**
         * <p>
         * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as
         * a default.
         * </p>
         * 
         * @param features
         *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
         *        used as a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(String... features);

        /**
         * <p>
         * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as
         * a default.
         * </p>
         * 
         * @param features
         *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
         *        used as a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<CustomizationFeature> features);

        /**
         * <p>
         * Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is used as
         * a default.
         * </p>
         * 
         * @param features
         *        Specifies the type of customization to filter projects by. If no value is specified, CUSTOM_LABELS is
         *        used as a default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(CustomizationFeature... features);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> projectNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            projectNames(model.projectNames);
            featuresWithStrings(model.features);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getProjectNames() {
            if (projectNames instanceof SdkAutoConstructList) {
                return null;
            }
            return projectNames;
        }

        public final void setProjectNames(Collection<String> projectNames) {
            this.projectNames = ProjectNamesCopier.copy(projectNames);
        }

        @Override
        public final Builder projectNames(Collection<String> projectNames) {
            this.projectNames = ProjectNamesCopier.copy(projectNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectNames(String... projectNames) {
            projectNames(Arrays.asList(projectNames));
            return this;
        }

        public final Collection<String> getFeatures() {
            if (features instanceof SdkAutoConstructList) {
                return null;
            }
            return features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = CustomizationFeaturesCopier.copy(features);
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = CustomizationFeaturesCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String... features) {
            featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<CustomizationFeature> features) {
            this.features = CustomizationFeaturesCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(CustomizationFeature... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProjectsRequest build() {
            return new DescribeProjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
