/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.AgeRange;
import software.amazon.awssdk.services.rekognition.model.Beard;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.Emotion;
import software.amazon.awssdk.services.rekognition.model.EmotionsCopier;
import software.amazon.awssdk.services.rekognition.model.EyeOpen;
import software.amazon.awssdk.services.rekognition.model.Eyeglasses;
import software.amazon.awssdk.services.rekognition.model.Gender;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.MouthOpen;
import software.amazon.awssdk.services.rekognition.model.Mustache;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.services.rekognition.model.Smile;
import software.amazon.awssdk.services.rekognition.model.Sunglasses;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FaceDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FaceDetail> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(FaceDetail.getter(FaceDetail::boundingBox)).setter(FaceDetail.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<AgeRange> AGE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgeRange").getter(FaceDetail.getter(FaceDetail::ageRange)).setter(FaceDetail.setter(Builder::ageRange)).constructor(AgeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgeRange").build()}).build();
    private static final SdkField<Smile> SMILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Smile").getter(FaceDetail.getter(FaceDetail::smile)).setter(FaceDetail.setter(Builder::smile)).constructor(Smile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Smile").build()}).build();
    private static final SdkField<Eyeglasses> EYEGLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Eyeglasses").getter(FaceDetail.getter(FaceDetail::eyeglasses)).setter(FaceDetail.setter(Builder::eyeglasses)).constructor(Eyeglasses::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Eyeglasses").build()}).build();
    private static final SdkField<Sunglasses> SUNGLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sunglasses").getter(FaceDetail.getter(FaceDetail::sunglasses)).setter(FaceDetail.setter(Builder::sunglasses)).constructor(Sunglasses::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sunglasses").build()}).build();
    private static final SdkField<Gender> GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Gender").getter(FaceDetail.getter(FaceDetail::gender)).setter(FaceDetail.setter(Builder::gender)).constructor(Gender::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()}).build();
    private static final SdkField<Beard> BEARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Beard").getter(FaceDetail.getter(FaceDetail::beard)).setter(FaceDetail.setter(Builder::beard)).constructor(Beard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Beard").build()}).build();
    private static final SdkField<Mustache> MUSTACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mustache").getter(FaceDetail.getter(FaceDetail::mustache)).setter(FaceDetail.setter(Builder::mustache)).constructor(Mustache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mustache").build()}).build();
    private static final SdkField<EyeOpen> EYES_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EyesOpen").getter(FaceDetail.getter(FaceDetail::eyesOpen)).setter(FaceDetail.setter(Builder::eyesOpen)).constructor(EyeOpen::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EyesOpen").build()}).build();
    private static final SdkField<MouthOpen> MOUTH_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MouthOpen").getter(FaceDetail.getter(FaceDetail::mouthOpen)).setter(FaceDetail.setter(Builder::mouthOpen)).constructor(MouthOpen::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MouthOpen").build()}).build();
    private static final SdkField<List<Emotion>> EMOTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Emotions").getter(FaceDetail.getter(FaceDetail::emotions)).setter(FaceDetail.setter(Builder::emotions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emotions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Emotion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Landmark>> LANDMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Landmarks").getter(FaceDetail.getter(FaceDetail::landmarks)).setter(FaceDetail.setter(Builder::landmarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Landmarks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Landmark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Pose> POSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pose").getter(FaceDetail.getter(FaceDetail::pose)).setter(FaceDetail.setter(Builder::pose)).constructor(Pose::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pose").build()}).build();
    private static final SdkField<ImageQuality> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Quality").getter(FaceDetail.getter(FaceDetail::quality)).setter(FaceDetail.setter(Builder::quality)).constructor(ImageQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quality").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(FaceDetail.getter(FaceDetail::confidence)).setter(FaceDetail.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, AGE_RANGE_FIELD, SMILE_FIELD, EYEGLASSES_FIELD, SUNGLASSES_FIELD, GENDER_FIELD, BEARD_FIELD, MUSTACHE_FIELD, EYES_OPEN_FIELD, MOUTH_OPEN_FIELD, EMOTIONS_FIELD, LANDMARKS_FIELD, POSE_FIELD, QUALITY_FIELD, CONFIDENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final BoundingBox boundingBox;
    private final AgeRange ageRange;
    private final Smile smile;
    private final Eyeglasses eyeglasses;
    private final Sunglasses sunglasses;
    private final Gender gender;
    private final Beard beard;
    private final Mustache mustache;
    private final EyeOpen eyesOpen;
    private final MouthOpen mouthOpen;
    private final List<Emotion> emotions;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;
    private final Float confidence;

    private FaceDetail(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.ageRange = builder.ageRange;
        this.smile = builder.smile;
        this.eyeglasses = builder.eyeglasses;
        this.sunglasses = builder.sunglasses;
        this.gender = builder.gender;
        this.beard = builder.beard;
        this.mustache = builder.mustache;
        this.eyesOpen = builder.eyesOpen;
        this.mouthOpen = builder.mouthOpen;
        this.emotions = builder.emotions;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
        this.confidence = builder.confidence;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final AgeRange ageRange() {
        return this.ageRange;
    }

    public final Smile smile() {
        return this.smile;
    }

    public final Eyeglasses eyeglasses() {
        return this.eyeglasses;
    }

    public final Sunglasses sunglasses() {
        return this.sunglasses;
    }

    public final Gender gender() {
        return this.gender;
    }

    public final Beard beard() {
        return this.beard;
    }

    public final Mustache mustache() {
        return this.mustache;
    }

    public final EyeOpen eyesOpen() {
        return this.eyesOpen;
    }

    public final MouthOpen mouthOpen() {
        return this.mouthOpen;
    }

    public final boolean hasEmotions() {
        return this.emotions != null && !(this.emotions instanceof SdkAutoConstructList);
    }

    public final List<Emotion> emotions() {
        return this.emotions;
    }

    public final boolean hasLandmarks() {
        return this.landmarks != null && !(this.landmarks instanceof SdkAutoConstructList);
    }

    public final List<Landmark> landmarks() {
        return this.landmarks;
    }

    public final Pose pose() {
        return this.pose;
    }

    public final ImageQuality quality() {
        return this.quality;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.ageRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.smile());
        hashCode = 31 * hashCode + Objects.hashCode(this.eyeglasses());
        hashCode = 31 * hashCode + Objects.hashCode(this.sunglasses());
        hashCode = 31 * hashCode + Objects.hashCode(this.gender());
        hashCode = 31 * hashCode + Objects.hashCode(this.beard());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustache());
        hashCode = 31 * hashCode + Objects.hashCode(this.eyesOpen());
        hashCode = 31 * hashCode + Objects.hashCode(this.mouthOpen());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmotions() ? this.emotions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLandmarks() ? this.landmarks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pose());
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetail)) {
            return false;
        }
        FaceDetail other = (FaceDetail)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.ageRange(), other.ageRange()) && Objects.equals(this.smile(), other.smile()) && Objects.equals(this.eyeglasses(), other.eyeglasses()) && Objects.equals(this.sunglasses(), other.sunglasses()) && Objects.equals(this.gender(), other.gender()) && Objects.equals(this.beard(), other.beard()) && Objects.equals(this.mustache(), other.mustache()) && Objects.equals(this.eyesOpen(), other.eyesOpen()) && Objects.equals(this.mouthOpen(), other.mouthOpen()) && this.hasEmotions() == other.hasEmotions() && Objects.equals(this.emotions(), other.emotions()) && this.hasLandmarks() == other.hasLandmarks() && Objects.equals(this.landmarks(), other.landmarks()) && Objects.equals(this.pose(), other.pose()) && Objects.equals(this.quality(), other.quality()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"FaceDetail").add("BoundingBox", (Object)this.boundingBox()).add("AgeRange", (Object)this.ageRange()).add("Smile", (Object)this.smile()).add("Eyeglasses", (Object)this.eyeglasses()).add("Sunglasses", (Object)this.sunglasses()).add("Gender", (Object)this.gender()).add("Beard", (Object)this.beard()).add("Mustache", (Object)this.mustache()).add("EyesOpen", (Object)this.eyesOpen()).add("MouthOpen", (Object)this.mouthOpen()).add("Emotions", this.hasEmotions() ? this.emotions() : null).add("Landmarks", this.hasLandmarks() ? this.landmarks() : null).add("Pose", (Object)this.pose()).add("Quality", (Object)this.quality()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "AgeRange": {
                return Optional.ofNullable(clazz.cast(this.ageRange()));
            }
            case "Smile": {
                return Optional.ofNullable(clazz.cast(this.smile()));
            }
            case "Eyeglasses": {
                return Optional.ofNullable(clazz.cast(this.eyeglasses()));
            }
            case "Sunglasses": {
                return Optional.ofNullable(clazz.cast(this.sunglasses()));
            }
            case "Gender": {
                return Optional.ofNullable(clazz.cast(this.gender()));
            }
            case "Beard": {
                return Optional.ofNullable(clazz.cast(this.beard()));
            }
            case "Mustache": {
                return Optional.ofNullable(clazz.cast(this.mustache()));
            }
            case "EyesOpen": {
                return Optional.ofNullable(clazz.cast(this.eyesOpen()));
            }
            case "MouthOpen": {
                return Optional.ofNullable(clazz.cast(this.mouthOpen()));
            }
            case "Emotions": {
                return Optional.ofNullable(clazz.cast(this.emotions()));
            }
            case "Landmarks": {
                return Optional.ofNullable(clazz.cast(this.landmarks()));
            }
            case "Pose": {
                return Optional.ofNullable(clazz.cast(this.pose()));
            }
            case "Quality": {
                return Optional.ofNullable(clazz.cast(this.quality()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceDetail, T> g) {
        return obj -> g.apply((FaceDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private AgeRange ageRange;
        private Smile smile;
        private Eyeglasses eyeglasses;
        private Sunglasses sunglasses;
        private Gender gender;
        private Beard beard;
        private Mustache mustache;
        private EyeOpen eyesOpen;
        private MouthOpen mouthOpen;
        private List<Emotion> emotions = DefaultSdkAutoConstructList.getInstance();
        private List<Landmark> landmarks = DefaultSdkAutoConstructList.getInstance();
        private Pose pose;
        private ImageQuality quality;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetail model) {
            this.boundingBox(model.boundingBox);
            this.ageRange(model.ageRange);
            this.smile(model.smile);
            this.eyeglasses(model.eyeglasses);
            this.sunglasses(model.sunglasses);
            this.gender(model.gender);
            this.beard(model.beard);
            this.mustache(model.mustache);
            this.eyesOpen(model.eyesOpen);
            this.mouthOpen(model.mouthOpen);
            this.emotions(model.emotions);
            this.landmarks(model.landmarks);
            this.pose(model.pose);
            this.quality(model.quality);
            this.confidence(model.confidence);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final AgeRange.Builder getAgeRange() {
            return this.ageRange != null ? this.ageRange.toBuilder() : null;
        }

        public final void setAgeRange(AgeRange.BuilderImpl ageRange) {
            this.ageRange = ageRange != null ? ageRange.build() : null;
        }

        @Override
        public final Builder ageRange(AgeRange ageRange) {
            this.ageRange = ageRange;
            return this;
        }

        public final Smile.Builder getSmile() {
            return this.smile != null ? this.smile.toBuilder() : null;
        }

        public final void setSmile(Smile.BuilderImpl smile) {
            this.smile = smile != null ? smile.build() : null;
        }

        @Override
        public final Builder smile(Smile smile) {
            this.smile = smile;
            return this;
        }

        public final Eyeglasses.Builder getEyeglasses() {
            return this.eyeglasses != null ? this.eyeglasses.toBuilder() : null;
        }

        public final void setEyeglasses(Eyeglasses.BuilderImpl eyeglasses) {
            this.eyeglasses = eyeglasses != null ? eyeglasses.build() : null;
        }

        @Override
        public final Builder eyeglasses(Eyeglasses eyeglasses) {
            this.eyeglasses = eyeglasses;
            return this;
        }

        public final Sunglasses.Builder getSunglasses() {
            return this.sunglasses != null ? this.sunglasses.toBuilder() : null;
        }

        public final void setSunglasses(Sunglasses.BuilderImpl sunglasses) {
            this.sunglasses = sunglasses != null ? sunglasses.build() : null;
        }

        @Override
        public final Builder sunglasses(Sunglasses sunglasses) {
            this.sunglasses = sunglasses;
            return this;
        }

        public final Gender.Builder getGender() {
            return this.gender != null ? this.gender.toBuilder() : null;
        }

        public final void setGender(Gender.BuilderImpl gender) {
            this.gender = gender != null ? gender.build() : null;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public final Beard.Builder getBeard() {
            return this.beard != null ? this.beard.toBuilder() : null;
        }

        public final void setBeard(Beard.BuilderImpl beard) {
            this.beard = beard != null ? beard.build() : null;
        }

        @Override
        public final Builder beard(Beard beard) {
            this.beard = beard;
            return this;
        }

        public final Mustache.Builder getMustache() {
            return this.mustache != null ? this.mustache.toBuilder() : null;
        }

        public final void setMustache(Mustache.BuilderImpl mustache) {
            this.mustache = mustache != null ? mustache.build() : null;
        }

        @Override
        public final Builder mustache(Mustache mustache) {
            this.mustache = mustache;
            return this;
        }

        public final EyeOpen.Builder getEyesOpen() {
            return this.eyesOpen != null ? this.eyesOpen.toBuilder() : null;
        }

        public final void setEyesOpen(EyeOpen.BuilderImpl eyesOpen) {
            this.eyesOpen = eyesOpen != null ? eyesOpen.build() : null;
        }

        @Override
        public final Builder eyesOpen(EyeOpen eyesOpen) {
            this.eyesOpen = eyesOpen;
            return this;
        }

        public final MouthOpen.Builder getMouthOpen() {
            return this.mouthOpen != null ? this.mouthOpen.toBuilder() : null;
        }

        public final void setMouthOpen(MouthOpen.BuilderImpl mouthOpen) {
            this.mouthOpen = mouthOpen != null ? mouthOpen.build() : null;
        }

        @Override
        public final Builder mouthOpen(MouthOpen mouthOpen) {
            this.mouthOpen = mouthOpen;
            return this;
        }

        public final List<Emotion.Builder> getEmotions() {
            List<Emotion.Builder> result = EmotionsCopier.copyToBuilder(this.emotions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmotions(Collection<Emotion.BuilderImpl> emotions) {
            this.emotions = EmotionsCopier.copyFromBuilder(emotions);
        }

        @Override
        public final Builder emotions(Collection<Emotion> emotions) {
            this.emotions = EmotionsCopier.copy(emotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Emotion ... emotions) {
            this.emotions(Arrays.asList(emotions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Consumer<Emotion.Builder> ... emotions) {
            this.emotions(Stream.of(emotions).map(c -> (Emotion)((Emotion.Builder)Emotion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Landmark.Builder> getLandmarks() {
            List<Landmark.Builder> result = LandmarksCopier.copyToBuilder(this.landmarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLandmarks(Collection<Landmark.BuilderImpl> landmarks) {
            this.landmarks = LandmarksCopier.copyFromBuilder(landmarks);
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Consumer<Landmark.Builder> ... landmarks) {
            this.landmarks(Stream.of(landmarks).map(c -> (Landmark)((Landmark.Builder)Landmark.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Pose.Builder getPose() {
            return this.pose != null ? this.pose.toBuilder() : null;
        }

        public final void setPose(Pose.BuilderImpl pose) {
            this.pose = pose != null ? pose.build() : null;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final ImageQuality.Builder getQuality() {
            return this.quality != null ? this.quality.toBuilder() : null;
        }

        public final void setQuality(ImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public FaceDetail build() {
            return new FaceDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FaceDetail> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder ageRange(AgeRange var1);

        default public Builder ageRange(Consumer<AgeRange.Builder> ageRange) {
            return this.ageRange((AgeRange)((AgeRange.Builder)AgeRange.builder().applyMutation(ageRange)).build());
        }

        public Builder smile(Smile var1);

        default public Builder smile(Consumer<Smile.Builder> smile) {
            return this.smile((Smile)((Smile.Builder)Smile.builder().applyMutation(smile)).build());
        }

        public Builder eyeglasses(Eyeglasses var1);

        default public Builder eyeglasses(Consumer<Eyeglasses.Builder> eyeglasses) {
            return this.eyeglasses((Eyeglasses)((Eyeglasses.Builder)Eyeglasses.builder().applyMutation(eyeglasses)).build());
        }

        public Builder sunglasses(Sunglasses var1);

        default public Builder sunglasses(Consumer<Sunglasses.Builder> sunglasses) {
            return this.sunglasses((Sunglasses)((Sunglasses.Builder)Sunglasses.builder().applyMutation(sunglasses)).build());
        }

        public Builder gender(Gender var1);

        default public Builder gender(Consumer<Gender.Builder> gender) {
            return this.gender((Gender)((Gender.Builder)Gender.builder().applyMutation(gender)).build());
        }

        public Builder beard(Beard var1);

        default public Builder beard(Consumer<Beard.Builder> beard) {
            return this.beard((Beard)((Beard.Builder)Beard.builder().applyMutation(beard)).build());
        }

        public Builder mustache(Mustache var1);

        default public Builder mustache(Consumer<Mustache.Builder> mustache) {
            return this.mustache((Mustache)((Mustache.Builder)Mustache.builder().applyMutation(mustache)).build());
        }

        public Builder eyesOpen(EyeOpen var1);

        default public Builder eyesOpen(Consumer<EyeOpen.Builder> eyesOpen) {
            return this.eyesOpen((EyeOpen)((EyeOpen.Builder)EyeOpen.builder().applyMutation(eyesOpen)).build());
        }

        public Builder mouthOpen(MouthOpen var1);

        default public Builder mouthOpen(Consumer<MouthOpen.Builder> mouthOpen) {
            return this.mouthOpen((MouthOpen)((MouthOpen.Builder)MouthOpen.builder().applyMutation(mouthOpen)).build());
        }

        public Builder emotions(Collection<Emotion> var1);

        public Builder emotions(Emotion ... var1);

        public Builder emotions(Consumer<Emotion.Builder> ... var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder landmarks(Consumer<Landmark.Builder> ... var1);

        public Builder pose(Pose var1);

        default public Builder pose(Consumer<Pose.Builder> pose) {
            return this.pose((Pose)((Pose.Builder)Pose.builder().applyMutation(pose)).build());
        }

        public Builder quality(ImageQuality var1);

        default public Builder quality(Consumer<ImageQuality.Builder> quality) {
            return this.quality((ImageQuality)((ImageQuality.Builder)ImageQuality.builder().applyMutation(quality)).build());
        }

        public Builder confidence(Float var1);
    }
}

