/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EmotionName {
    HAPPY("HAPPY"),
    SAD("SAD"),
    ANGRY("ANGRY"),
    CONFUSED("CONFUSED"),
    DISGUSTED("DISGUSTED"),
    SURPRISED("SURPRISED"),
    CALM("CALM"),
    UNKNOWN("UNKNOWN"),
    FEAR("FEAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EmotionName> VALUE_MAP;
    private final String value;

    private EmotionName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EmotionName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EmotionName> knownValues() {
        EnumSet<EmotionName> knownValues = EnumSet.allOf(EmotionName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EmotionName.class, EmotionName::toString);
    }
}

