/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DatasetEntriesCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetEntriesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListDatasetEntriesResponse> {
    private static final SdkField<List<String>> DATASET_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetEntries").getter(ListDatasetEntriesResponse.getter(ListDatasetEntriesResponse::datasetEntries)).setter(ListDatasetEntriesResponse.setter(Builder::datasetEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetEntriesResponse.getter(ListDatasetEntriesResponse::nextToken)).setter(ListDatasetEntriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> datasetEntries;
    private final String nextToken;

    private ListDatasetEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.datasetEntries = builder.datasetEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetEntries() {
        return this.datasetEntries != null && !(this.datasetEntries instanceof SdkAutoConstructList);
    }

    public final List<String> datasetEntries() {
        return this.datasetEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetEntries() ? this.datasetEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesResponse)) {
            return false;
        }
        ListDatasetEntriesResponse other = (ListDatasetEntriesResponse)((Object)obj);
        return this.hasDatasetEntries() == other.hasDatasetEntries() && Objects.equals(this.datasetEntries(), other.datasetEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetEntriesResponse").add("DatasetEntries", this.hasDatasetEntries() ? this.datasetEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetEntries": {
                return Optional.ofNullable(clazz.cast(this.datasetEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesResponse, T> g) {
        return obj -> g.apply((ListDatasetEntriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> datasetEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesResponse model) {
            super(model);
            this.datasetEntries(model.datasetEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDatasetEntries() {
            if (this.datasetEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetEntries;
        }

        public final void setDatasetEntries(Collection<String> datasetEntries) {
            this.datasetEntries = DatasetEntriesCopier.copy(datasetEntries);
        }

        @Override
        public final Builder datasetEntries(Collection<String> datasetEntries) {
            this.datasetEntries = DatasetEntriesCopier.copy(datasetEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetEntries(String ... datasetEntries) {
            this.datasetEntries(Arrays.asList(datasetEntries));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetEntriesResponse build() {
            return new ListDatasetEntriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetEntriesResponse> {
        public Builder datasetEntries(Collection<String> var1);

        public Builder datasetEntries(String ... var1);

        public Builder nextToken(String var1);
    }
}

