/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributeDatasetEntriesRequest extends RekognitionRequest implements
        ToCopyableBuilder<DistributeDatasetEntriesRequest.Builder, DistributeDatasetEntriesRequest> {
    private static final SdkField<List<DistributeDataset>> DATASETS_FIELD = SdkField
            .<List<DistributeDataset>> builder(MarshallingType.LIST)
            .memberName("Datasets")
            .getter(getter(DistributeDatasetEntriesRequest::datasets))
            .setter(setter(Builder::datasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DistributeDataset> builder(MarshallingType.SDK_POJO)
                                            .constructor(DistributeDataset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD));

    private final List<DistributeDataset> datasets;

    private DistributeDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Datasets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatasets() {
        return datasets != null && !(datasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same
     * project. The test dataset must be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasets} method.
     * </p>
     * 
     * @return The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the
     *         same project. The test dataset must be empty.
     */
    public final List<DistributeDataset> datasets() {
        return datasets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasets() ? datasets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributeDatasetEntriesRequest)) {
            return false;
        }
        DistributeDatasetEntriesRequest other = (DistributeDatasetEntriesRequest) obj;
        return hasDatasets() == other.hasDatasets() && Objects.equals(datasets(), other.datasets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributeDatasetEntriesRequest").add("Datasets", hasDatasets() ? datasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Datasets":
            return Optional.ofNullable(clazz.cast(datasets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributeDatasetEntriesRequest, T> g) {
        return obj -> g.apply((DistributeDatasetEntriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DistributeDatasetEntriesRequest> {
        /**
         * <p>
         * The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same
         * project. The test dataset must be empty.
         * </p>
         * 
         * @param datasets
         *        The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to
         *        the same project. The test dataset must be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(Collection<DistributeDataset> datasets);

        /**
         * <p>
         * The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same
         * project. The test dataset must be empty.
         * </p>
         * 
         * @param datasets
         *        The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to
         *        the same project. The test dataset must be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(DistributeDataset... datasets);

        /**
         * <p>
         * The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same
         * project. The test dataset must be empty.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.DistributeDataset.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rekognition.model.DistributeDataset#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.DistributeDataset.Builder#build()} is called
         * immediately and its result is passed to {@link #datasets(List<DistributeDataset>)}.
         * 
         * @param datasets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.DistributeDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasets(java.util.Collection<DistributeDataset>)
         */
        Builder datasets(Consumer<DistributeDataset.Builder>... datasets);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private List<DistributeDataset> datasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributeDatasetEntriesRequest model) {
            super(model);
            datasets(model.datasets);
        }

        public final List<DistributeDataset.Builder> getDatasets() {
            List<DistributeDataset.Builder> result = DistributeDatasetMetadataListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DistributeDataset.BuilderImpl> datasets) {
            this.datasets = DistributeDatasetMetadataListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DistributeDataset> datasets) {
            this.datasets = DistributeDatasetMetadataListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DistributeDataset... datasets) {
            datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DistributeDataset.Builder>... datasets) {
            datasets(Stream.of(datasets).map(c -> DistributeDataset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DistributeDatasetEntriesRequest build() {
            return new DistributeDatasetEntriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
