/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The quality of an image provided for label detection, with regard to brightness, sharpness, and contrast.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsImageQuality implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectLabelsImageQuality.Builder, DetectLabelsImageQuality> {
    private static final SdkField<Float> BRIGHTNESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Brightness").getter(getter(DetectLabelsImageQuality::brightness)).setter(setter(Builder::brightness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brightness").build()).build();

    private static final SdkField<Float> SHARPNESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Sharpness").getter(getter(DetectLabelsImageQuality::sharpness)).setter(setter(Builder::sharpness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sharpness").build()).build();

    private static final SdkField<Float> CONTRAST_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Contrast")
            .getter(getter(DetectLabelsImageQuality::contrast)).setter(setter(Builder::contrast))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contrast").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIGHTNESS_FIELD,
            SHARPNESS_FIELD, CONTRAST_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float brightness;

    private final Float sharpness;

    private final Float contrast;

    private DetectLabelsImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
        this.contrast = builder.contrast;
    }

    /**
     * <p>
     * The brightness of an image provided for label detection.
     * </p>
     * 
     * @return The brightness of an image provided for label detection.
     */
    public final Float brightness() {
        return brightness;
    }

    /**
     * <p>
     * The sharpness of an image provided for label detection.
     * </p>
     * 
     * @return The sharpness of an image provided for label detection.
     */
    public final Float sharpness() {
        return sharpness;
    }

    /**
     * <p>
     * The contrast of an image provided for label detection.
     * </p>
     * 
     * @return The contrast of an image provided for label detection.
     */
    public final Float contrast() {
        return contrast;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brightness());
        hashCode = 31 * hashCode + Objects.hashCode(sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(contrast());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsImageQuality)) {
            return false;
        }
        DetectLabelsImageQuality other = (DetectLabelsImageQuality) obj;
        return Objects.equals(brightness(), other.brightness()) && Objects.equals(sharpness(), other.sharpness())
                && Objects.equals(contrast(), other.contrast());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectLabelsImageQuality").add("Brightness", brightness()).add("Sharpness", sharpness())
                .add("Contrast", contrast()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Brightness":
            return Optional.ofNullable(clazz.cast(brightness()));
        case "Sharpness":
            return Optional.ofNullable(clazz.cast(sharpness()));
        case "Contrast":
            return Optional.ofNullable(clazz.cast(contrast()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsImageQuality, T> g) {
        return obj -> g.apply((DetectLabelsImageQuality) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectLabelsImageQuality> {
        /**
         * <p>
         * The brightness of an image provided for label detection.
         * </p>
         * 
         * @param brightness
         *        The brightness of an image provided for label detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brightness(Float brightness);

        /**
         * <p>
         * The sharpness of an image provided for label detection.
         * </p>
         * 
         * @param sharpness
         *        The sharpness of an image provided for label detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Float sharpness);

        /**
         * <p>
         * The contrast of an image provided for label detection.
         * </p>
         * 
         * @param contrast
         *        The contrast of an image provided for label detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contrast(Float contrast);
    }

    static final class BuilderImpl implements Builder {
        private Float brightness;

        private Float sharpness;

        private Float contrast;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsImageQuality model) {
            brightness(model.brightness);
            sharpness(model.sharpness);
            contrast(model.contrast);
        }

        public final Float getBrightness() {
            return brightness;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final Float getSharpness() {
            return sharpness;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final Float getContrast() {
            return contrast;
        }

        public final void setContrast(Float contrast) {
            this.contrast = contrast;
        }

        @Override
        public final Builder contrast(Float contrast) {
            this.contrast = contrast;
            return this;
        }

        @Override
        public DetectLabelsImageQuality build() {
            return new DetectLabelsImageQuality(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
