/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FaceRecordListCopier {
    static List<FaceRecord> copy(Collection<? extends FaceRecord> faceRecordListParam) {
        List<FaceRecord> list;
        if (faceRecordListParam == null || faceRecordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FaceRecord> modifiableList = new ArrayList<>();
            faceRecordListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FaceRecord> copyFromBuilder(Collection<? extends FaceRecord.Builder> faceRecordListParam) {
        List<FaceRecord> list;
        if (faceRecordListParam == null || faceRecordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FaceRecord> modifiableList = new ArrayList<>();
            faceRecordListParam.forEach(entry -> {
                FaceRecord member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FaceRecord.Builder> copyToBuilder(Collection<? extends FaceRecord> faceRecordListParam) {
        List<FaceRecord.Builder> list;
        if (faceRecordListParam == null || faceRecordListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FaceRecord.Builder> modifiableList = new ArrayList<>();
            faceRecordListParam.forEach(entry -> {
                FaceRecord.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
