/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListFacesResponse> {
    private static final SdkField<List<Face>> FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Faces").getter(ListFacesResponse.getter(ListFacesResponse::faces)).setter(ListFacesResponse.setter(Builder::faces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Faces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Face::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFacesResponse.getter(ListFacesResponse::nextToken)).setter(ListFacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceModelVersion").getter(ListFacesResponse.getter(ListFacesResponse::faceModelVersion)).setter(ListFacesResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACES_FIELD, NEXT_TOKEN_FIELD, FACE_MODEL_VERSION_FIELD));
    private final List<Face> faces;
    private final String nextToken;
    private final String faceModelVersion;

    private ListFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
        this.faceModelVersion = builder.faceModelVersion;
    }

    public final boolean hasFaces() {
        return this.faces != null && !(this.faces instanceof SdkAutoConstructList);
    }

    public final List<Face> faces() {
        return this.faces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String faceModelVersion() {
        return this.faceModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaces() ? this.faces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse)((Object)obj);
        return this.hasFaces() == other.hasFaces() && Objects.equals(this.faces(), other.faces()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ListFacesResponse").add("Faces", this.hasFaces() ? this.faces() : null).add("NextToken", (Object)this.nextToken()).add("FaceModelVersion", (Object)this.faceModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Faces": {
                return Optional.ofNullable(clazz.cast(this.faces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFacesResponse, T> g) {
        return obj -> g.apply((ListFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Face> faces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            super(model);
            this.faces(model.faces);
            this.nextToken(model.nextToken);
            this.faceModelVersion(model.faceModelVersion);
        }

        public final List<Face.Builder> getFaces() {
            List<Face.Builder> result = FaceListCopier.copyToBuilder(this.faces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaces(Collection<Face.BuilderImpl> faces) {
            this.faces = FaceListCopier.copyFromBuilder(faces);
        }

        @Override
        @Transient
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faces(Face ... faces) {
            this.faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faces(Consumer<Face.Builder> ... faces) {
            this.faces(Stream.of(faces).map(c -> (Face)((Face.Builder)Face.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        @Transient
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        @Override
        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFacesResponse> {
        public Builder faces(Collection<Face> var1);

        public Builder faces(Face ... var1);

        public Builder faces(Consumer<Face.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder faceModelVersion(String var1);
    }
}

