/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.HumanLoopDataAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanLoopConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanLoopConfig> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopName").getter(HumanLoopConfig.getter(HumanLoopConfig::humanLoopName)).setter(HumanLoopConfig.setter(Builder::humanLoopName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionArn").getter(HumanLoopConfig.getter(HumanLoopConfig::flowDefinitionArn)).setter(HumanLoopConfig.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final SdkField<HumanLoopDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataAttributes").getter(HumanLoopConfig.getter(HumanLoopConfig::dataAttributes)).setter(HumanLoopConfig.setter(Builder::dataAttributes)).constructor(HumanLoopDataAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD, FLOW_DEFINITION_ARN_FIELD, DATA_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String humanLoopName;
    private final String flowDefinitionArn;
    private final HumanLoopDataAttributes dataAttributes;

    private HumanLoopConfig(BuilderImpl builder) {
        this.humanLoopName = builder.humanLoopName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.dataAttributes = builder.dataAttributes;
    }

    public final String humanLoopName() {
        return this.humanLoopName;
    }

    public final String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public final HumanLoopDataAttributes dataAttributes() {
        return this.dataAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopConfig)) {
            return false;
        }
        HumanLoopConfig other = (HumanLoopConfig)obj;
        return Objects.equals(this.humanLoopName(), other.humanLoopName()) && Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.dataAttributes(), other.dataAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"HumanLoopConfig").add("HumanLoopName", (Object)this.humanLoopName()).add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("DataAttributes", (Object)this.dataAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanLoopName": {
                return Optional.ofNullable(clazz.cast(this.humanLoopName()));
            }
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "DataAttributes": {
                return Optional.ofNullable(clazz.cast(this.dataAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopConfig, T> g) {
        return obj -> g.apply((HumanLoopConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String humanLoopName;
        private String flowDefinitionArn;
        private HumanLoopDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopConfig model) {
            this.humanLoopName(model.humanLoopName);
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.dataAttributes(model.dataAttributes);
        }

        public final String getHumanLoopName() {
            return this.humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        @Transient
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        @Transient
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final HumanLoopDataAttributes.Builder getDataAttributes() {
            return this.dataAttributes != null ? this.dataAttributes.toBuilder() : null;
        }

        public final void setDataAttributes(HumanLoopDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder dataAttributes(HumanLoopDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        public HumanLoopConfig build() {
            return new HumanLoopConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanLoopConfig> {
        public Builder humanLoopName(String var1);

        public Builder flowDefinitionArn(String var1);

        public Builder dataAttributes(HumanLoopDataAttributes var1);

        default public Builder dataAttributes(Consumer<HumanLoopDataAttributes.Builder> dataAttributes) {
            return this.dataAttributes((HumanLoopDataAttributes)((HumanLoopDataAttributes.Builder)HumanLoopDataAttributes.builder().applyMutation(dataAttributes)).build());
        }
    }
}

