/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a dataset label. For more information, see <a>ListDatasetLabels</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetLabelDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetLabelDescription.Builder, DatasetLabelDescription> {
    private static final SdkField<String> LABEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelName").getter(getter(DatasetLabelDescription::labelName)).setter(setter(Builder::labelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelName").build()).build();

    private static final SdkField<DatasetLabelStats> LABEL_STATS_FIELD = SdkField
            .<DatasetLabelStats> builder(MarshallingType.SDK_POJO).memberName("LabelStats")
            .getter(getter(DatasetLabelDescription::labelStats)).setter(setter(Builder::labelStats))
            .constructor(DatasetLabelStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelStats").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_NAME_FIELD,
            LABEL_STATS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String labelName;

    private final DatasetLabelStats labelStats;

    private DatasetLabelDescription(BuilderImpl builder) {
        this.labelName = builder.labelName;
        this.labelStats = builder.labelStats;
    }

    /**
     * <p>
     * The name of the label.
     * </p>
     * 
     * @return The name of the label.
     */
    public final String labelName() {
        return labelName;
    }

    /**
     * <p>
     * Statistics about the label.
     * </p>
     * 
     * @return Statistics about the label.
     */
    public final DatasetLabelStats labelStats() {
        return labelStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelName());
        hashCode = 31 * hashCode + Objects.hashCode(labelStats());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetLabelDescription)) {
            return false;
        }
        DatasetLabelDescription other = (DatasetLabelDescription) obj;
        return Objects.equals(labelName(), other.labelName()) && Objects.equals(labelStats(), other.labelStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetLabelDescription").add("LabelName", labelName()).add("LabelStats", labelStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelName":
            return Optional.ofNullable(clazz.cast(labelName()));
        case "LabelStats":
            return Optional.ofNullable(clazz.cast(labelStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetLabelDescription, T> g) {
        return obj -> g.apply((DatasetLabelDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetLabelDescription> {
        /**
         * <p>
         * The name of the label.
         * </p>
         * 
         * @param labelName
         *        The name of the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelName(String labelName);

        /**
         * <p>
         * Statistics about the label.
         * </p>
         * 
         * @param labelStats
         *        Statistics about the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelStats(DatasetLabelStats labelStats);

        /**
         * <p>
         * Statistics about the label.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetLabelStats.Builder} avoiding the need to
         * create one manually via {@link DatasetLabelStats#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetLabelStats.Builder#build()} is called immediately and its
         * result is passed to {@link #labelStats(DatasetLabelStats)}.
         * 
         * @param labelStats
         *        a consumer that will call methods on {@link DatasetLabelStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelStats(DatasetLabelStats)
         */
        default Builder labelStats(Consumer<DatasetLabelStats.Builder> labelStats) {
            return labelStats(DatasetLabelStats.builder().applyMutation(labelStats).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String labelName;

        private DatasetLabelStats labelStats;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetLabelDescription model) {
            labelName(model.labelName);
            labelStats(model.labelStats);
        }

        public final String getLabelName() {
            return labelName;
        }

        public final void setLabelName(String labelName) {
            this.labelName = labelName;
        }

        @Override
        @Transient
        public final Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        public final DatasetLabelStats.Builder getLabelStats() {
            return labelStats != null ? labelStats.toBuilder() : null;
        }

        public final void setLabelStats(DatasetLabelStats.BuilderImpl labelStats) {
            this.labelStats = labelStats != null ? labelStats.build() : null;
        }

        @Override
        @Transient
        public final Builder labelStats(DatasetLabelStats labelStats) {
            this.labelStats = labelStats;
            return this;
        }

        @Override
        public DatasetLabelDescription build() {
            return new DatasetLabelDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
