/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamProcessorRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateStreamProcessorRequest.Builder, CreateStreamProcessorRequest> {
    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField
            .<StreamProcessorInput> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(CreateStreamProcessorRequest::input)).setter(setter(Builder::input))
            .constructor(StreamProcessorInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField
            .<StreamProcessorOutput> builder(MarshallingType.SDK_POJO).memberName("Output")
            .getter(getter(CreateStreamProcessorRequest::output)).setter(setter(Builder::output))
            .constructor(StreamProcessorOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateStreamProcessorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField
            .<StreamProcessorSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(CreateStreamProcessorRequest::settings)).setter(setter(Builder::settings))
            .constructor(StreamProcessorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateStreamProcessorRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateStreamProcessorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD,
            NAME_FIELD, SETTINGS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));

    private final StreamProcessorInput input;

    private final StreamProcessorOutput output;

    private final String name;

    private final StreamProcessorSettings settings;

    private final String roleArn;

    private final Map<String, String> tags;

    private CreateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.output = builder.output;
        this.name = builder.name;
        this.settings = builder.settings;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter
     * name is <code>StreamProcessorInput</code>.
     * </p>
     * 
     * @return Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
     *         parameter name is <code>StreamProcessorInput</code>.
     */
    public final StreamProcessorInput input() {
        return input;
    }

    /**
     * <p>
     * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS
     * CLI, the parameter name is <code>StreamProcessorOutput</code>.
     * </p>
     * 
     * @return Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using
     *         the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
     */
    public final StreamProcessorOutput output() {
        return output;
    }

    /**
     * <p>
     * An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor.
     * For example, you can get the current status of the stream processor by calling <a>DescribeStreamProcessor</a>.
     * <code>Name</code> is idempotent.
     * </p>
     * 
     * @return An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
     *         processor. For example, you can get the current status of the stream processor by calling
     *         <a>DescribeStreamProcessor</a>. <code>Name</code> is idempotent.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
     * recognition and the face attributes to detect.
     * </p>
     * 
     * @return Face recognition input parameters to be used by the stream processor. Includes the collection to use for
     *         face recognition and the face attributes to detect.
     */
    public final StreamProcessorSettings settings() {
        return settings;
    }

    /**
     * <p>
     * ARN of the IAM role that allows access to the stream processor.
     * </p>
     * 
     * @return ARN of the IAM role that allows access to the stream processor.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the stream processor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the stream processor.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorRequest)) {
            return false;
        }
        CreateStreamProcessorRequest other = (CreateStreamProcessorRequest) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(output(), other.output())
                && Objects.equals(name(), other.name()) && Objects.equals(settings(), other.settings())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamProcessorRequest").add("Input", input()).add("Output", output()).add("Name", name())
                .add("Settings", settings()).add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamProcessorRequest, T> g) {
        return obj -> g.apply((CreateStreamProcessorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamProcessorRequest> {
        /**
         * <p>
         * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
         * parameter name is <code>StreamProcessorInput</code>.
         * </p>
         * 
         * @param input
         *        Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI,
         *        the parameter name is <code>StreamProcessorInput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(StreamProcessorInput input);

        /**
         * <p>
         * Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the
         * parameter name is <code>StreamProcessorInput</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorInput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorInput.Builder#build()} is called immediately and
         * its result is passed to {@link #input(StreamProcessorInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link StreamProcessorInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(StreamProcessorInput)
         */
        default Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return input(StreamProcessorInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the
         * AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * </p>
         * 
         * @param output
         *        Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are
         *        using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(StreamProcessorOutput output);

        /**
         * <p>
         * Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the
         * AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorOutput.Builder} avoiding the need
         * to create one manually via {@link StreamProcessorOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(StreamProcessorOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link StreamProcessorOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(StreamProcessorOutput)
         */
        default Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return output(StreamProcessorOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
         * processor. For example, you can get the current status of the stream processor by calling
         * <a>DescribeStreamProcessor</a>. <code>Name</code> is idempotent.
         * </p>
         * 
         * @param name
         *        An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream
         *        processor. For example, you can get the current status of the stream processor by calling
         *        <a>DescribeStreamProcessor</a>. <code>Name</code> is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
         * recognition and the face attributes to detect.
         * </p>
         * 
         * @param settings
         *        Face recognition input parameters to be used by the stream processor. Includes the collection to use
         *        for face recognition and the face attributes to detect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(StreamProcessorSettings settings);

        /**
         * <p>
         * Face recognition input parameters to be used by the stream processor. Includes the collection to use for face
         * recognition and the face attributes to detect.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamProcessorSettings.Builder} avoiding the
         * need to create one manually via {@link StreamProcessorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(StreamProcessorSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link StreamProcessorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(StreamProcessorSettings)
         */
        default Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return settings(StreamProcessorSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * ARN of the IAM role that allows access to the stream processor.
         * </p>
         * 
         * @param roleArn
         *        ARN of the IAM role that allows access to the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the stream processor.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private StreamProcessorInput input;

        private StreamProcessorOutput output;

        private String name;

        private StreamProcessorSettings settings;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamProcessorRequest model) {
            super(model);
            input(model.input);
            output(model.output);
            name(model.name);
            settings(model.settings);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final StreamProcessorInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        @Transient
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        @Transient
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamProcessorRequest build() {
            return new CreateStreamProcessorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
