/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentPersonIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectiveEquipmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectiveEquipmentSummary> {
    private static final SdkField<List<Integer>> PERSONS_WITH_REQUIRED_EQUIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PersonsWithRequiredEquipment").getter(ProtectiveEquipmentSummary.getter(ProtectiveEquipmentSummary::personsWithRequiredEquipment)).setter(ProtectiveEquipmentSummary.setter(Builder::personsWithRequiredEquipment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsWithRequiredEquipment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PERSONS_WITHOUT_REQUIRED_EQUIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PersonsWithoutRequiredEquipment").getter(ProtectiveEquipmentSummary.getter(ProtectiveEquipmentSummary::personsWithoutRequiredEquipment)).setter(ProtectiveEquipmentSummary.setter(Builder::personsWithoutRequiredEquipment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsWithoutRequiredEquipment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PERSONS_INDETERMINATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PersonsIndeterminate").getter(ProtectiveEquipmentSummary.getter(ProtectiveEquipmentSummary::personsIndeterminate)).setter(ProtectiveEquipmentSummary.setter(Builder::personsIndeterminate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsIndeterminate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONS_WITH_REQUIRED_EQUIPMENT_FIELD, PERSONS_WITHOUT_REQUIRED_EQUIPMENT_FIELD, PERSONS_INDETERMINATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Integer> personsWithRequiredEquipment;
    private final List<Integer> personsWithoutRequiredEquipment;
    private final List<Integer> personsIndeterminate;

    private ProtectiveEquipmentSummary(BuilderImpl builder) {
        this.personsWithRequiredEquipment = builder.personsWithRequiredEquipment;
        this.personsWithoutRequiredEquipment = builder.personsWithoutRequiredEquipment;
        this.personsIndeterminate = builder.personsIndeterminate;
    }

    public final boolean hasPersonsWithRequiredEquipment() {
        return this.personsWithRequiredEquipment != null && !(this.personsWithRequiredEquipment instanceof SdkAutoConstructList);
    }

    public final List<Integer> personsWithRequiredEquipment() {
        return this.personsWithRequiredEquipment;
    }

    public final boolean hasPersonsWithoutRequiredEquipment() {
        return this.personsWithoutRequiredEquipment != null && !(this.personsWithoutRequiredEquipment instanceof SdkAutoConstructList);
    }

    public final List<Integer> personsWithoutRequiredEquipment() {
        return this.personsWithoutRequiredEquipment;
    }

    public final boolean hasPersonsIndeterminate() {
        return this.personsIndeterminate != null && !(this.personsIndeterminate instanceof SdkAutoConstructList);
    }

    public final List<Integer> personsIndeterminate() {
        return this.personsIndeterminate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonsWithRequiredEquipment() ? this.personsWithRequiredEquipment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonsWithoutRequiredEquipment() ? this.personsWithoutRequiredEquipment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonsIndeterminate() ? this.personsIndeterminate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentSummary)) {
            return false;
        }
        ProtectiveEquipmentSummary other = (ProtectiveEquipmentSummary)obj;
        return this.hasPersonsWithRequiredEquipment() == other.hasPersonsWithRequiredEquipment() && Objects.equals(this.personsWithRequiredEquipment(), other.personsWithRequiredEquipment()) && this.hasPersonsWithoutRequiredEquipment() == other.hasPersonsWithoutRequiredEquipment() && Objects.equals(this.personsWithoutRequiredEquipment(), other.personsWithoutRequiredEquipment()) && this.hasPersonsIndeterminate() == other.hasPersonsIndeterminate() && Objects.equals(this.personsIndeterminate(), other.personsIndeterminate());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectiveEquipmentSummary").add("PersonsWithRequiredEquipment", this.hasPersonsWithRequiredEquipment() ? this.personsWithRequiredEquipment() : null).add("PersonsWithoutRequiredEquipment", this.hasPersonsWithoutRequiredEquipment() ? this.personsWithoutRequiredEquipment() : null).add("PersonsIndeterminate", this.hasPersonsIndeterminate() ? this.personsIndeterminate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PersonsWithRequiredEquipment": {
                return Optional.ofNullable(clazz.cast(this.personsWithRequiredEquipment()));
            }
            case "PersonsWithoutRequiredEquipment": {
                return Optional.ofNullable(clazz.cast(this.personsWithoutRequiredEquipment()));
            }
            case "PersonsIndeterminate": {
                return Optional.ofNullable(clazz.cast(this.personsIndeterminate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentSummary, T> g) {
        return obj -> g.apply((ProtectiveEquipmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> personsWithRequiredEquipment = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> personsWithoutRequiredEquipment = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> personsIndeterminate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentSummary model) {
            this.personsWithRequiredEquipment(model.personsWithRequiredEquipment);
            this.personsWithoutRequiredEquipment(model.personsWithoutRequiredEquipment);
            this.personsIndeterminate(model.personsIndeterminate);
        }

        public final Collection<Integer> getPersonsWithRequiredEquipment() {
            if (this.personsWithRequiredEquipment instanceof SdkAutoConstructList) {
                return null;
            }
            return this.personsWithRequiredEquipment;
        }

        public final void setPersonsWithRequiredEquipment(Collection<Integer> personsWithRequiredEquipment) {
            this.personsWithRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithRequiredEquipment);
        }

        @Override
        public final Builder personsWithRequiredEquipment(Collection<Integer> personsWithRequiredEquipment) {
            this.personsWithRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithRequiredEquipment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsWithRequiredEquipment(Integer ... personsWithRequiredEquipment) {
            this.personsWithRequiredEquipment(Arrays.asList(personsWithRequiredEquipment));
            return this;
        }

        public final Collection<Integer> getPersonsWithoutRequiredEquipment() {
            if (this.personsWithoutRequiredEquipment instanceof SdkAutoConstructList) {
                return null;
            }
            return this.personsWithoutRequiredEquipment;
        }

        public final void setPersonsWithoutRequiredEquipment(Collection<Integer> personsWithoutRequiredEquipment) {
            this.personsWithoutRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithoutRequiredEquipment);
        }

        @Override
        public final Builder personsWithoutRequiredEquipment(Collection<Integer> personsWithoutRequiredEquipment) {
            this.personsWithoutRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithoutRequiredEquipment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsWithoutRequiredEquipment(Integer ... personsWithoutRequiredEquipment) {
            this.personsWithoutRequiredEquipment(Arrays.asList(personsWithoutRequiredEquipment));
            return this;
        }

        public final Collection<Integer> getPersonsIndeterminate() {
            if (this.personsIndeterminate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.personsIndeterminate;
        }

        public final void setPersonsIndeterminate(Collection<Integer> personsIndeterminate) {
            this.personsIndeterminate = ProtectiveEquipmentPersonIdsCopier.copy(personsIndeterminate);
        }

        @Override
        public final Builder personsIndeterminate(Collection<Integer> personsIndeterminate) {
            this.personsIndeterminate = ProtectiveEquipmentPersonIdsCopier.copy(personsIndeterminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsIndeterminate(Integer ... personsIndeterminate) {
            this.personsIndeterminate(Arrays.asList(personsIndeterminate));
            return this;
        }

        public ProtectiveEquipmentSummary build() {
            return new ProtectiveEquipmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectiveEquipmentSummary> {
        public Builder personsWithRequiredEquipment(Collection<Integer> var1);

        public Builder personsWithRequiredEquipment(Integer ... var1);

        public Builder personsWithoutRequiredEquipment(Collection<Integer> var1);

        public Builder personsWithoutRequiredEquipment(Integer ... var1);

        public Builder personsIndeterminate(Collection<Integer> var1);

        public Builder personsIndeterminate(Integer ... var1);
    }
}

