/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, DetectLabelsRequest> {
    private static final SdkField<Image> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(DetectLabelsRequest.getter(DetectLabelsRequest::image)).setter(DetectLabelsRequest.setter(Builder::image)).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Integer> MAX_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLabels").getter(DetectLabelsRequest.getter(DetectLabelsRequest::maxLabels)).setter(DetectLabelsRequest.setter(Builder::maxLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLabels").build()}).build();
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(DetectLabelsRequest.getter(DetectLabelsRequest::minConfidence)).setter(DetectLabelsRequest.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, MAX_LABELS_FIELD, MIN_CONFIDENCE_FIELD));
    private final Image image;
    private final Integer maxLabels;
    private final Float minConfidence;

    private DetectLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.image = builder.image;
        this.maxLabels = builder.maxLabels;
        this.minConfidence = builder.minConfidence;
    }

    public final Image image() {
        return this.image;
    }

    public final Integer maxLabels() {
        return this.maxLabels;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsRequest)) {
            return false;
        }
        DetectLabelsRequest other = (DetectLabelsRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.maxLabels(), other.maxLabels()) && Objects.equals(this.minConfidence(), other.minConfidence());
    }

    public final String toString() {
        return ToString.builder((String)"DetectLabelsRequest").add("Image", (Object)this.image()).add("MaxLabels", (Object)this.maxLabels()).add("MinConfidence", (Object)this.minConfidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MaxLabels": {
                return Optional.ofNullable(clazz.cast(this.maxLabels()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsRequest, T> g) {
        return obj -> g.apply((DetectLabelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private Image image;
        private Integer maxLabels;
        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsRequest model) {
            super(model);
            this.image(model.image);
            this.maxLabels(model.maxLabels);
            this.minConfidence(model.minConfidence);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        @Transient
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Integer getMaxLabels() {
            return this.maxLabels;
        }

        public final void setMaxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
        }

        @Override
        @Transient
        public final Builder maxLabels(Integer maxLabels) {
            this.maxLabels = maxLabels;
            return this;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        @Transient
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectLabelsRequest build() {
            return new DetectLabelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectLabelsRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder maxLabels(Integer var1);

        public Builder minConfidence(Float var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

