/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Asset;
import software.amazon.awssdk.services.rekognition.model.AssetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestingData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestingData> {
    private static final SdkField<List<Asset>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assets").getter(TestingData.getter(TestingData::assets)).setter(TestingData.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Asset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoCreate").getter(TestingData.getter(TestingData::autoCreate)).setter(TestingData.setter(Builder::autoCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, AUTO_CREATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Asset> assets;
    private final Boolean autoCreate;

    private TestingData(BuilderImpl builder) {
        this.assets = builder.assets;
        this.autoCreate = builder.autoCreate;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<Asset> assets() {
        return this.assets;
    }

    public final Boolean autoCreate() {
        return this.autoCreate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestingData)) {
            return false;
        }
        TestingData other = (TestingData)obj;
        return this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.autoCreate(), other.autoCreate());
    }

    public final String toString() {
        return ToString.builder((String)"TestingData").add("Assets", this.hasAssets() ? this.assets() : null).add("AutoCreate", (Object)this.autoCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "AutoCreate": {
                return Optional.ofNullable(clazz.cast(this.autoCreate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestingData, T> g) {
        return obj -> g.apply((TestingData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Asset> assets = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(TestingData model) {
            this.assets(model.assets);
            this.autoCreate(model.autoCreate);
        }

        public final List<Asset.Builder> getAssets() {
            List<Asset.Builder> result = AssetsCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<Asset.BuilderImpl> assets) {
            this.assets = AssetsCopier.copyFromBuilder(assets);
        }

        @Override
        @Transient
        public final Builder assets(Collection<Asset> assets) {
            this.assets = AssetsCopier.copy(assets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assets(Asset ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assets(Consumer<Asset.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (Asset)((Asset.Builder)Asset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        @Transient
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public TestingData build() {
            return new TestingData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestingData> {
        public Builder assets(Collection<Asset> var1);

        public Builder assets(Asset ... var1);

        public Builder assets(Consumer<Asset.Builder> ... var1);

        public Builder autoCreate(Boolean var1);
    }
}

