/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Kinesis Data Streams stream to which a Amazon Rekognition Video stream processor streams
 * the results of a video analysis. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer
 * Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessorOutput.Builder, StreamProcessorOutput> {
    private static final SdkField<KinesisDataStream> KINESIS_DATA_STREAM_FIELD = SdkField
            .<KinesisDataStream> builder(MarshallingType.SDK_POJO).memberName("KinesisDataStream")
            .getter(getter(StreamProcessorOutput::kinesisDataStream)).setter(setter(Builder::kinesisDataStream))
            .constructor(KinesisDataStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_DATA_STREAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final KinesisDataStream kinesisDataStream;

    private StreamProcessorOutput(BuilderImpl builder) {
        this.kinesisDataStream = builder.kinesisDataStream;
    }

    /**
     * <p>
     * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
     * results.
     * </p>
     * 
     * @return The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the
     *         analysis results.
     */
    public final KinesisDataStream kinesisDataStream() {
        return kinesisDataStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisDataStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorOutput)) {
            return false;
        }
        StreamProcessorOutput other = (StreamProcessorOutput) obj;
        return Objects.equals(kinesisDataStream(), other.kinesisDataStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessorOutput").add("KinesisDataStream", kinesisDataStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisDataStream":
            return Optional.ofNullable(clazz.cast(kinesisDataStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorOutput, T> g) {
        return obj -> g.apply((StreamProcessorOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessorOutput> {
        /**
         * <p>
         * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
         * results.
         * </p>
         * 
         * @param kinesisDataStream
         *        The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the
         *        analysis results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataStream(KinesisDataStream kinesisDataStream);

        /**
         * <p>
         * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis
         * results.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisDataStream.Builder} avoiding the need to
         * create one manually via {@link KinesisDataStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisDataStream.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisDataStream(KinesisDataStream)}.
         * 
         * @param kinesisDataStream
         *        a consumer that will call methods on {@link KinesisDataStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataStream(KinesisDataStream)
         */
        default Builder kinesisDataStream(Consumer<KinesisDataStream.Builder> kinesisDataStream) {
            return kinesisDataStream(KinesisDataStream.builder().applyMutation(kinesisDataStream).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisDataStream kinesisDataStream;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorOutput model) {
            kinesisDataStream(model.kinesisDataStream);
        }

        public final KinesisDataStream.Builder getKinesisDataStream() {
            return kinesisDataStream != null ? kinesisDataStream.toBuilder() : null;
        }

        public final void setKinesisDataStream(KinesisDataStream.BuilderImpl kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream != null ? kinesisDataStream.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisDataStream(KinesisDataStream kinesisDataStream) {
            this.kinesisDataStream = kinesisDataStream;
            return this;
        }

        @Override
        public StreamProcessorOutput build() {
            return new StreamProcessorOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
