/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sagemaker Groundtruth format manifest files for the input, output and validation datasets that are used and created
 * during testing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestingDataResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TestingDataResult.Builder, TestingDataResult> {
    private static final SdkField<TestingData> INPUT_FIELD = SdkField.<TestingData> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(TestingDataResult::input)).setter(setter(Builder::input))
            .constructor(TestingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<TestingData> OUTPUT_FIELD = SdkField.<TestingData> builder(MarshallingType.SDK_POJO)
            .memberName("Output").getter(getter(TestingDataResult::output)).setter(setter(Builder::output))
            .constructor(TestingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<ValidationData> VALIDATION_FIELD = SdkField.<ValidationData> builder(MarshallingType.SDK_POJO)
            .memberName("Validation").getter(getter(TestingDataResult::validation)).setter(setter(Builder::validation))
            .constructor(ValidationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD,
            VALIDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TestingData input;

    private final TestingData output;

    private final ValidationData validation;

    private TestingDataResult(BuilderImpl builder) {
        this.input = builder.input;
        this.output = builder.output;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * The testing dataset that was supplied for training.
     * </p>
     * 
     * @return The testing dataset that was supplied for training.
     */
    public final TestingData input() {
        return input;
    }

    /**
     * <p>
     * The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file
     * formatting and other issues.
     * </p>
     * 
     * @return The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file
     *         formatting and other issues.
     */
    public final TestingData output() {
        return output;
    }

    /**
     * <p>
     * The location of the data validation manifest. The data validation manifest is created for the test dataset during
     * model training.
     * </p>
     * 
     * @return The location of the data validation manifest. The data validation manifest is created for the test
     *         dataset during model training.
     */
    public final ValidationData validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestingDataResult)) {
            return false;
        }
        TestingDataResult other = (TestingDataResult) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(output(), other.output())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestingDataResult").add("Input", input()).add("Output", output())
                .add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestingDataResult, T> g) {
        return obj -> g.apply((TestingDataResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestingDataResult> {
        /**
         * <p>
         * The testing dataset that was supplied for training.
         * </p>
         * 
         * @param input
         *        The testing dataset that was supplied for training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(TestingData input);

        /**
         * <p>
         * The testing dataset that was supplied for training.
         * </p>
         * This is a convenience that creates an instance of the {@link TestingData.Builder} avoiding the need to create
         * one manually via {@link TestingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestingData.Builder#build()} is called immediately and its result
         * is passed to {@link #input(TestingData)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link TestingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(TestingData)
         */
        default Builder input(Consumer<TestingData.Builder> input) {
            return input(TestingData.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file
         * formatting and other issues.
         * </p>
         * 
         * @param output
         *        The subset of the dataset that was actually tested. Some images (assets) might not be tested due to
         *        file formatting and other issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(TestingData output);

        /**
         * <p>
         * The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file
         * formatting and other issues.
         * </p>
         * This is a convenience that creates an instance of the {@link TestingData.Builder} avoiding the need to create
         * one manually via {@link TestingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestingData.Builder#build()} is called immediately and its result
         * is passed to {@link #output(TestingData)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link TestingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(TestingData)
         */
        default Builder output(Consumer<TestingData.Builder> output) {
            return output(TestingData.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * The location of the data validation manifest. The data validation manifest is created for the test dataset
         * during model training.
         * </p>
         * 
         * @param validation
         *        The location of the data validation manifest. The data validation manifest is created for the test
         *        dataset during model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(ValidationData validation);

        /**
         * <p>
         * The location of the data validation manifest. The data validation manifest is created for the test dataset
         * during model training.
         * </p>
         * This is a convenience that creates an instance of the {@link ValidationData.Builder} avoiding the need to
         * create one manually via {@link ValidationData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValidationData.Builder#build()} is called immediately and its
         * result is passed to {@link #validation(ValidationData)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link ValidationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(ValidationData)
         */
        default Builder validation(Consumer<ValidationData.Builder> validation) {
            return validation(ValidationData.builder().applyMutation(validation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TestingData input;

        private TestingData output;

        private ValidationData validation;

        private BuilderImpl() {
        }

        private BuilderImpl(TestingDataResult model) {
            input(model.input);
            output(model.output);
            validation(model.validation);
        }

        public final TestingData.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(TestingData input) {
            this.input = input;
            return this;
        }

        public final void setInput(TestingData.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final TestingData.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        @Override
        public final Builder output(TestingData output) {
            this.output = output;
            return this;
        }

        public final void setOutput(TestingData.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final ValidationData.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        @Override
        public final Builder validation(ValidationData validation) {
            this.validation = validation;
            return this;
        }

        public final void setValidation(ValidationData.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public TestingDataResult build() {
            return new TestingDataResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
