/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<IndexFacesResponse.Builder, IndexFacesResponse> {
    private static final SdkField<List<FaceRecord>> FACE_RECORDS_FIELD = SdkField
            .<List<FaceRecord>> builder(MarshallingType.LIST)
            .memberName("FaceRecords")
            .getter(getter(IndexFacesResponse::faceRecords))
            .setter(setter(Builder::faceRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaceRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaceRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrientationCorrection").getter(getter(IndexFacesResponse::orientationCorrectionAsString))
            .setter(setter(Builder::orientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build())
            .build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceModelVersion").getter(getter(IndexFacesResponse::faceModelVersion))
            .setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final SdkField<List<UnindexedFace>> UNINDEXED_FACES_FIELD = SdkField
            .<List<UnindexedFace>> builder(MarshallingType.LIST)
            .memberName("UnindexedFaces")
            .getter(getter(IndexFacesResponse::unindexedFaces))
            .setter(setter(Builder::unindexedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnindexedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnindexedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnindexedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_RECORDS_FIELD,
            ORIENTATION_CORRECTION_FIELD, FACE_MODEL_VERSION_FIELD, UNINDEXED_FACES_FIELD));

    private final List<FaceRecord> faceRecords;

    private final String orientationCorrection;

    private final String faceModelVersion;

    private final List<UnindexedFace> unindexedFaces;

    private IndexFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
        this.faceModelVersion = builder.faceModelVersion;
        this.unindexedFaces = builder.unindexedFaces;
    }

    /**
     * Returns true if the FaceRecords property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFaceRecords() {
        return faceRecords != null && !(faceRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of faces detected and added to the collection. For more information, see Searching Faces in a Collection
     * in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFaceRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of faces detected and added to the collection. For more information, see Searching Faces in a
     *         Collection in the Amazon Rekognition Developer Guide.
     */
    public final List<FaceRecord> faceRecords() {
        return faceRecords;
    }

    /**
     * <p>
     * If your collection is associated with a face detection model that's later than version 3.0, the value of
     * <code>OrientationCorrection</code> is always null and no orientation information is returned.
     * </p>
     * <p>
     * If your collection is associated with a face detection model that's version 3.0 or earlier, the following
     * applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction - the bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata. The value of <code>OrientationCorrection</code> is null.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
     * estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image
     * correction for images. The bounding box coordinates aren't translated and represent the object locations before
     * the image is rotated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the face
     * detection model by calling <a>DescribeCollection</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return If your collection is associated with a face detection model that's later than version 3.0, the value of
     *         <code>OrientationCorrection</code> is always null and no orientation information is returned.</p>
     *         <p>
     *         If your collection is associated with a face detection model that's version 3.0 or earlier, the following
     *         applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction - the bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
     *         estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform
     *         image correction for images. The bounding box coordinates aren't translated and represent the object
     *         locations before the image is rotated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of
     *         the face detection model by calling <a>DescribeCollection</a>.
     * @see OrientationCorrection
     */
    public final OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * If your collection is associated with a face detection model that's later than version 3.0, the value of
     * <code>OrientationCorrection</code> is always null and no orientation information is returned.
     * </p>
     * <p>
     * If your collection is associated with a face detection model that's version 3.0 or earlier, the following
     * applies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction - the bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata. The value of <code>OrientationCorrection</code> is null.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
     * estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image
     * correction for images. The bounding box coordinates aren't translated and represent the object locations before
     * the image is rotated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the face
     * detection model by calling <a>DescribeCollection</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return If your collection is associated with a face detection model that's later than version 3.0, the value of
     *         <code>OrientationCorrection</code> is always null and no orientation information is returned.</p>
     *         <p>
     *         If your collection is associated with a face detection model that's version 3.0 or earlier, the following
     *         applies:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction - the bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
     *         estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform
     *         image correction for images. The bounding box coordinates aren't translated and represent the object
     *         locations before the image is rotated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of
     *         the face detection model by calling <a>DescribeCollection</a>.
     * @see OrientationCorrection
     */
    public final String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    /**
     * <p>
     * The version number of the face detection model that's associated with the input collection (
     * <code>CollectionId</code>).
     * </p>
     * 
     * @return The version number of the face detection model that's associated with the input collection (
     *         <code>CollectionId</code>).
     */
    public final String faceModelVersion() {
        return faceModelVersion;
    }

    /**
     * Returns true if the UnindexedFaces property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUnindexedFaces() {
        return unindexedFaces != null && !(unindexedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the quality
     * filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them out. To use
     * the quality filter, you specify the <code>QualityFilter</code> request parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnindexedFaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of faces that were detected in the image but weren't indexed. They weren't indexed because the
     *         quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered
     *         them out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.
     */
    public final List<UnindexedFace> unindexedFaces() {
        return unindexedFaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFaceRecords() ? faceRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnindexedFaces() ? unindexedFaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse) obj;
        return hasFaceRecords() == other.hasFaceRecords() && Objects.equals(faceRecords(), other.faceRecords())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString())
                && Objects.equals(faceModelVersion(), other.faceModelVersion())
                && hasUnindexedFaces() == other.hasUnindexedFaces() && Objects.equals(unindexedFaces(), other.unindexedFaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexFacesResponse").add("FaceRecords", hasFaceRecords() ? faceRecords() : null)
                .add("OrientationCorrection", orientationCorrectionAsString()).add("FaceModelVersion", faceModelVersion())
                .add("UnindexedFaces", hasUnindexedFaces() ? unindexedFaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceRecords":
            return Optional.ofNullable(clazz.cast(faceRecords()));
        case "OrientationCorrection":
            return Optional.ofNullable(clazz.cast(orientationCorrectionAsString()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        case "UnindexedFaces":
            return Optional.ofNullable(clazz.cast(unindexedFaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexFacesResponse, T> g) {
        return obj -> g.apply((IndexFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, IndexFacesResponse> {
        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see Searching Faces in a
         * Collection in the Amazon Rekognition Developer Guide.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see Searching Faces in a
         *        Collection in the Amazon Rekognition Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(Collection<FaceRecord> faceRecords);

        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see Searching Faces in a
         * Collection in the Amazon Rekognition Developer Guide.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see Searching Faces in a
         *        Collection in the Amazon Rekognition Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(FaceRecord... faceRecords);

        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see Searching Faces in a
         * Collection in the Amazon Rekognition Developer Guide.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceRecord>.Builder} avoiding the need to
         * create one manually via {@link List<FaceRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceRecord>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceRecords(List<FaceRecord>)}.
         * 
         * @param faceRecords
         *        a consumer that will call methods on {@link List<FaceRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceRecords(List<FaceRecord>)
         */
        Builder faceRecords(Consumer<FaceRecord.Builder>... faceRecords);

        /**
         * <p>
         * If your collection is associated with a face detection model that's later than version 3.0, the value of
         * <code>OrientationCorrection</code> is always null and no orientation information is returned.
         * </p>
         * <p>
         * If your collection is associated with a face detection model that's version 3.0 or earlier, the following
         * applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction - the bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
         * estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image
         * correction for images. The bounding box coordinates aren't translated and represent the object locations
         * before the image is rotated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the
         * face detection model by calling <a>DescribeCollection</a>.
         * </p>
         * 
         * @param orientationCorrection
         *        If your collection is associated with a face detection model that's later than version 3.0, the value
         *        of <code>OrientationCorrection</code> is always null and no orientation information is returned.</p>
         *        <p>
         *        If your collection is associated with a face detection model that's version 3.0 or earlier, the
         *        following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction - the bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns
         *        an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t
         *        perform image correction for images. The bounding box coordinates aren't translated and represent the
         *        object locations before the image is rotated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of
         *        the face detection model by calling <a>DescribeCollection</a>.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * If your collection is associated with a face detection model that's later than version 3.0, the value of
         * <code>OrientationCorrection</code> is always null and no orientation information is returned.
         * </p>
         * <p>
         * If your collection is associated with a face detection model that's version 3.0 or earlier, the following
         * applies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction - the bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an
         * estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image
         * correction for images. The bounding box coordinates aren't translated and represent the object locations
         * before the image is rotated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the
         * face detection model by calling <a>DescribeCollection</a>.
         * </p>
         * 
         * @param orientationCorrection
         *        If your collection is associated with a face detection model that's later than version 3.0, the value
         *        of <code>OrientationCorrection</code> is always null and no orientation information is returned.</p>
         *        <p>
         *        If your collection is associated with a face detection model that's version 3.0 or earlier, the
         *        following applies:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction - the bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata. The value of <code>OrientationCorrection</code> is null.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns
         *        an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t
         *        perform image correction for images. The bounding box coordinates aren't translated and represent the
         *        object locations before the image is rotated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of
         *        the face detection model by calling <a>DescribeCollection</a>.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);

        /**
         * <p>
         * The version number of the face detection model that's associated with the input collection (
         * <code>CollectionId</code>).
         * </p>
         * 
         * @param faceModelVersion
         *        The version number of the face detection model that's associated with the input collection (
         *        <code>CollectionId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);

        /**
         * <p>
         * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the
         * quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them
         * out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.
         * </p>
         * 
         * @param unindexedFaces
         *        An array of faces that were detected in the image but weren't indexed. They weren't indexed because
         *        the quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter
         *        filtered them out. To use the quality filter, you specify the <code>QualityFilter</code> request
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unindexedFaces(Collection<UnindexedFace> unindexedFaces);

        /**
         * <p>
         * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the
         * quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them
         * out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.
         * </p>
         * 
         * @param unindexedFaces
         *        An array of faces that were detected in the image but weren't indexed. They weren't indexed because
         *        the quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter
         *        filtered them out. To use the quality filter, you specify the <code>QualityFilter</code> request
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unindexedFaces(UnindexedFace... unindexedFaces);

        /**
         * <p>
         * An array of faces that were detected in the image but weren't indexed. They weren't indexed because the
         * quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them
         * out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnindexedFace>.Builder} avoiding the need
         * to create one manually via {@link List<UnindexedFace>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnindexedFace>.Builder#build()} is called immediately and
         * its result is passed to {@link #unindexedFaces(List<UnindexedFace>)}.
         * 
         * @param unindexedFaces
         *        a consumer that will call methods on {@link List<UnindexedFace>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unindexedFaces(List<UnindexedFace>)
         */
        Builder unindexedFaces(Consumer<UnindexedFace.Builder>... unindexedFaces);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<FaceRecord> faceRecords = DefaultSdkAutoConstructList.getInstance();

        private String orientationCorrection;

        private String faceModelVersion;

        private List<UnindexedFace> unindexedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            super(model);
            faceRecords(model.faceRecords);
            orientationCorrection(model.orientationCorrection);
            faceModelVersion(model.faceModelVersion);
            unindexedFaces(model.unindexedFaces);
        }

        public final List<FaceRecord.Builder> getFaceRecords() {
            List<FaceRecord.Builder> result = FaceRecordListCopier.copyToBuilder(this.faceRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord... faceRecords) {
            faceRecords(Arrays.asList(faceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(Consumer<FaceRecord.Builder>... faceRecords) {
            faceRecords(Stream.of(faceRecords).map(c -> FaceRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord.BuilderImpl> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copyFromBuilder(faceRecords);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        public final List<UnindexedFace.Builder> getUnindexedFaces() {
            List<UnindexedFace.Builder> result = UnindexedFacesCopier.copyToBuilder(this.unindexedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unindexedFaces(Collection<UnindexedFace> unindexedFaces) {
            this.unindexedFaces = UnindexedFacesCopier.copy(unindexedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unindexedFaces(UnindexedFace... unindexedFaces) {
            unindexedFaces(Arrays.asList(unindexedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unindexedFaces(Consumer<UnindexedFace.Builder>... unindexedFaces) {
            unindexedFaces(Stream.of(unindexedFaces).map(c -> UnindexedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnindexedFaces(Collection<UnindexedFace.BuilderImpl> unindexedFaces) {
            this.unindexedFaces = UnindexedFacesCopier.copyFromBuilder(unindexedFaces);
        }

        @Override
        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
