/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.model.LabelsCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectLabelsResponse> {
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(DetectLabelsResponse.getter(DetectLabelsResponse::labels)).setter(DetectLabelsResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Label::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrientationCorrection").getter(DetectLabelsResponse.getter(DetectLabelsResponse::orientationCorrectionAsString)).setter(DetectLabelsResponse.setter(Builder::orientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build()}).build();
    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelModelVersion").getter(DetectLabelsResponse.getter(DetectLabelsResponse::labelModelVersion)).setter(DetectLabelsResponse.setter(Builder::labelModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, ORIENTATION_CORRECTION_FIELD, LABEL_MODEL_VERSION_FIELD));
    private final List<Label> labels;
    private final String orientationCorrection;
    private final String labelModelVersion;

    private DetectLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
        this.labelModelVersion = builder.labelModelVersion;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<Label> labels() {
        return this.labels;
    }

    public final OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public final String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public final String labelModelVersion() {
        return this.labelModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse)((Object)obj);
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString()) && Objects.equals(this.labelModelVersion(), other.labelModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DetectLabelsResponse").add("Labels", this.hasLabels() ? this.labels() : null).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).add("LabelModelVersion", (Object)this.labelModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
            case "LabelModelVersion": {
                return Optional.ofNullable(clazz.cast(this.labelModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsResponse, T> g) {
        return obj -> g.apply((DetectLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;
        private String labelModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            super(model);
            this.labels(model.labels);
            this.orientationCorrection(model.orientationCorrection);
            this.labelModelVersion(model.labelModelVersion);
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (Label)((Label.Builder)Label.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final String getLabelModelVersion() {
            return this.labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectLabelsResponse> {
        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder labels(Consumer<Label.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);

        public Builder labelModelVersion(String var1);
    }
}

