/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorInput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamProcessorRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, CreateStreamProcessorRequest> {
    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::input)).setter(CreateStreamProcessorRequest.setter(Builder::input)).constructor(StreamProcessorInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Output").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::output)).setter(CreateStreamProcessorRequest.setter(Builder::output)).constructor(StreamProcessorOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::name)).setter(CreateStreamProcessorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::settings)).setter(CreateStreamProcessorRequest.setter(Builder::settings)).constructor(StreamProcessorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateStreamProcessorRequest.getter(CreateStreamProcessorRequest::roleArn)).setter(CreateStreamProcessorRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, OUTPUT_FIELD, NAME_FIELD, SETTINGS_FIELD, ROLE_ARN_FIELD));
    private final StreamProcessorInput input;
    private final StreamProcessorOutput output;
    private final String name;
    private final StreamProcessorSettings settings;
    private final String roleArn;

    private CreateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.output = builder.output;
        this.name = builder.name;
        this.settings = builder.settings;
        this.roleArn = builder.roleArn;
    }

    public final StreamProcessorInput input() {
        return this.input;
    }

    public final StreamProcessorOutput output() {
        return this.output;
    }

    public final String name() {
        return this.name;
    }

    public final StreamProcessorSettings settings() {
        return this.settings;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorRequest)) {
            return false;
        }
        CreateStreamProcessorRequest other = (CreateStreamProcessorRequest)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamProcessorRequest").add("Input", (Object)this.input()).add("Output", (Object)this.output()).add("Name", (Object)this.name()).add("Settings", (Object)this.settings()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamProcessorRequest, T> g) {
        return obj -> g.apply((CreateStreamProcessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private StreamProcessorInput input;
        private StreamProcessorOutput output;
        private String name;
        private StreamProcessorSettings settings;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamProcessorRequest model) {
            super(model);
            this.input(model.input);
            this.output(model.output);
            this.name(model.name);
            this.settings(model.settings);
            this.roleArn(model.roleArn);
        }

        public final StreamProcessorInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamProcessorRequest build() {
            return new CreateStreamProcessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamProcessorRequest> {
        public Builder input(StreamProcessorInput var1);

        default public Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return this.input((StreamProcessorInput)((StreamProcessorInput.Builder)StreamProcessorInput.builder().applyMutation(input)).build());
        }

        public Builder output(StreamProcessorOutput var1);

        default public Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return this.output((StreamProcessorOutput)((StreamProcessorOutput.Builder)StreamProcessorOutput.builder().applyMutation(output)).build());
        }

        public Builder name(String var1);

        public Builder settings(StreamProcessorSettings var1);

        default public Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return this.settings((StreamProcessorSettings)((StreamProcessorSettings.Builder)StreamProcessorSettings.builder().applyMutation(settings)).build());
        }

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

