/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectCustomLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectCustomLabelsResponse.Builder, DetectCustomLabelsResponse> {
    private static final SdkField<List<CustomLabel>> CUSTOM_LABELS_FIELD = SdkField
            .<List<CustomLabel>> builder(MarshallingType.LIST)
            .memberName("CustomLabels")
            .getter(getter(DetectCustomLabelsResponse::customLabels))
            .setter(setter(Builder::customLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LABELS_FIELD));

    private final List<CustomLabel> customLabels;

    private DetectCustomLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.customLabels = builder.customLabels;
    }

    /**
     * Returns true if the CustomLabels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCustomLabels() {
        return customLabels != null && !(customLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom labels detected in the input image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of custom labels detected in the input image.
     */
    public final List<CustomLabel> customLabels() {
        return customLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomLabels() ? customLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectCustomLabelsResponse)) {
            return false;
        }
        DetectCustomLabelsResponse other = (DetectCustomLabelsResponse) obj;
        return hasCustomLabels() == other.hasCustomLabels() && Objects.equals(customLabels(), other.customLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectCustomLabelsResponse").add("CustomLabels", hasCustomLabels() ? customLabels() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLabels":
            return Optional.ofNullable(clazz.cast(customLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectCustomLabelsResponse, T> g) {
        return obj -> g.apply((DetectCustomLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectCustomLabelsResponse> {
        /**
         * <p>
         * An array of custom labels detected in the input image.
         * </p>
         * 
         * @param customLabels
         *        An array of custom labels detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabels(Collection<CustomLabel> customLabels);

        /**
         * <p>
         * An array of custom labels detected in the input image.
         * </p>
         * 
         * @param customLabels
         *        An array of custom labels detected in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabels(CustomLabel... customLabels);

        /**
         * <p>
         * An array of custom labels detected in the input image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomLabel>.Builder} avoiding the need to
         * create one manually via {@link List<CustomLabel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomLabel>.Builder#build()} is called immediately and its
         * result is passed to {@link #customLabels(List<CustomLabel>)}.
         * 
         * @param customLabels
         *        a consumer that will call methods on {@link List<CustomLabel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLabels(List<CustomLabel>)
         */
        Builder customLabels(Consumer<CustomLabel.Builder>... customLabels);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<CustomLabel> customLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectCustomLabelsResponse model) {
            super(model);
            customLabels(model.customLabels);
        }

        public final Collection<CustomLabel.Builder> getCustomLabels() {
            if (customLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return customLabels != null ? customLabels.stream().map(CustomLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customLabels(Collection<CustomLabel> customLabels) {
            this.customLabels = CustomLabelsCopier.copy(customLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLabels(CustomLabel... customLabels) {
            customLabels(Arrays.asList(customLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLabels(Consumer<CustomLabel.Builder>... customLabels) {
            customLabels(Stream.of(customLabels).map(c -> CustomLabel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomLabels(Collection<CustomLabel.BuilderImpl> customLabels) {
            this.customLabels = CustomLabelsCopier.copyFromBuilder(customLabels);
        }

        @Override
        public DetectCustomLabelsResponse build() {
            return new DetectCustomLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
