/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContentModerationResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetContentModerationResponse.Builder, GetContentModerationResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetContentModerationResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetContentModerationResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).getter(getter(GetContentModerationResponse::videoMetadata))
            .setter(setter(Builder::videoMetadata)).constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<List<ContentModerationDetection>> MODERATION_LABELS_FIELD = SdkField
            .<List<ContentModerationDetection>> builder(MarshallingType.LIST)
            .getter(getter(GetContentModerationResponse::moderationLabels))
            .setter(setter(Builder::moderationLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContentModerationDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContentModerationDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetContentModerationResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> MODERATION_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetContentModerationResponse::moderationModelVersion)).setter(setter(Builder::moderationModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationModelVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, MODERATION_LABELS_FIELD, NEXT_TOKEN_FIELD,
                    MODERATION_MODEL_VERSION_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final VideoMetadata videoMetadata;

    private final List<ContentModerationDetection> moderationLabels;

    private final String nextToken;

    private final String moderationModelVersion;

    private GetContentModerationResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.moderationLabels = builder.moderationLabels;
        this.nextToken = builder.nextToken;
        this.moderationModelVersion = builder.moderationModelVersion;
    }

    /**
     * <p>
     * The current status of the unsafe content analysis job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the unsafe content analysis job.
     * @see VideoJobStatus
     */
    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the unsafe content analysis job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the unsafe content analysis job.
     * @see VideoJobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page
     * of paginated responses from <code>GetContentModeration</code>.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
     *         every page of paginated responses from <code>GetContentModeration</code>.
     */
    public VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * Returns true if the ModerationLabels property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasModerationLabels() {
        return moderationLabels != null && !(moderationLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The detected unsafe content labels and the time(s) they were detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModerationLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The detected unsafe content labels and the time(s) they were detected.
     */
    public List<ContentModerationDetection> moderationLabels() {
        return moderationLabels;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of unsafe content labels.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of unsafe content labels.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Version number of the moderation detection model that was used to detect unsafe content.
     * </p>
     * 
     * @return Version number of the moderation detection model that was used to detect unsafe content.
     */
    public String moderationModelVersion() {
        return moderationModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(moderationLabels());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(moderationModelVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentModerationResponse)) {
            return false;
        }
        GetContentModerationResponse other = (GetContentModerationResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(videoMetadata(), other.videoMetadata())
                && Objects.equals(moderationLabels(), other.moderationLabels()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(moderationModelVersion(), other.moderationModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetContentModerationResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("VideoMetadata", videoMetadata())
                .add("ModerationLabels", moderationLabels()).add("NextToken", nextToken())
                .add("ModerationModelVersion", moderationModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "ModerationLabels":
            return Optional.ofNullable(clazz.cast(moderationLabels()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ModerationModelVersion":
            return Optional.ofNullable(clazz.cast(moderationModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContentModerationResponse, T> g) {
        return obj -> g.apply((GetContentModerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContentModerationResponse> {
        /**
         * <p>
         * The current status of the unsafe content analysis job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the unsafe content analysis job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the unsafe content analysis job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the unsafe content analysis job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from <code>GetContentModeration</code>.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
         *        every page of paginated responses from <code>GetContentModeration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from <code>GetContentModeration</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link VideoMetadata.Builder} avoiding the need to
         * create one manually via {@link VideoMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * The detected unsafe content labels and the time(s) they were detected.
         * </p>
         * 
         * @param moderationLabels
         *        The detected unsafe content labels and the time(s) they were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(Collection<ContentModerationDetection> moderationLabels);

        /**
         * <p>
         * The detected unsafe content labels and the time(s) they were detected.
         * </p>
         * 
         * @param moderationLabels
         *        The detected unsafe content labels and the time(s) they were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(ContentModerationDetection... moderationLabels);

        /**
         * <p>
         * The detected unsafe content labels and the time(s) they were detected.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContentModerationDetection>.Builder}
         * avoiding the need to create one manually via {@link List<ContentModerationDetection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContentModerationDetection>.Builder#build()} is called
         * immediately and its result is passed to {@link #moderationLabels(List<ContentModerationDetection>)}.
         * 
         * @param moderationLabels
         *        a consumer that will call methods on {@link List<ContentModerationDetection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderationLabels(List<ContentModerationDetection>)
         */
        Builder moderationLabels(Consumer<ContentModerationDetection.Builder>... moderationLabels);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of unsafe content labels.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of unsafe content labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Version number of the moderation detection model that was used to detect unsafe content.
         * </p>
         * 
         * @param moderationModelVersion
         *        Version number of the moderation detection model that was used to detect unsafe content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationModelVersion(String moderationModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private VideoMetadata videoMetadata;

        private List<ContentModerationDetection> moderationLabels = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String moderationModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentModerationResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            videoMetadata(model.videoMetadata);
            moderationLabels(model.moderationLabels);
            nextToken(model.nextToken);
            moderationModelVersion(model.moderationModelVersion);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final Collection<ContentModerationDetection.Builder> getModerationLabels() {
            return moderationLabels != null ? moderationLabels.stream().map(ContentModerationDetection::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ContentModerationDetection> moderationLabels) {
            this.moderationLabels = ContentModerationDetectionsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ContentModerationDetection... moderationLabels) {
            moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ContentModerationDetection.Builder>... moderationLabels) {
            moderationLabels(Stream.of(moderationLabels).map(c -> ContentModerationDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModerationLabels(Collection<ContentModerationDetection.BuilderImpl> moderationLabels) {
            this.moderationLabels = ContentModerationDetectionsCopier.copyFromBuilder(moderationLabels);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getModerationModelVersion() {
            return moderationModelVersion;
        }

        @Override
        public final Builder moderationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
            return this;
        }

        public final void setModerationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
        }

        @Override
        public GetContentModerationResponse build() {
            return new GetContentModerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
