/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DeleteFacesResponse> {
    private static final SdkField<List<String>> DELETED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteFacesResponse.getter(DeleteFacesResponse::deletedFaces)).setter(DeleteFacesResponse.setter(Builder::deletedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FACES_FIELD));
    private final List<String> deletedFaces;

    private DeleteFacesResponse(BuilderImpl builder) {
        super(builder);
        this.deletedFaces = builder.deletedFaces;
    }

    public boolean hasDeletedFaces() {
        return this.deletedFaces != null && !(this.deletedFaces instanceof SdkAutoConstructList);
    }

    public List<String> deletedFaces() {
        return this.deletedFaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedFaces());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse)((Object)obj);
        return Objects.equals(this.deletedFaces(), other.deletedFaces());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFacesResponse").add("DeletedFaces", this.deletedFaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletedFaces": {
                return Optional.ofNullable(clazz.cast(this.deletedFaces()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFacesResponse, T> g) {
        return obj -> g.apply((DeleteFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<String> deletedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            super(model);
            this.deletedFaces(model.deletedFaces);
        }

        public final Collection<String> getDeletedFaces() {
            return this.deletedFaces;
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String ... deletedFaces) {
            this.deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        @Override
        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFacesResponse> {
        public Builder deletedFaces(Collection<String> var1);

        public Builder deletedFaces(String ... var1);
    }
}

