/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A face that <a>IndexFaces</a> detected, but didn't index. Use the <code>Reasons</code> response attribute to
 * determine why a face wasn't indexed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnindexedFace implements SdkPojo, Serializable, ToCopyableBuilder<UnindexedFace.Builder, UnindexedFace> {
    private static final SdkField<List<String>> REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UnindexedFace::reasonsAsStrings))
            .setter(setter(Builder::reasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FaceDetail> FACE_DETAIL_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(UnindexedFace::faceDetail)).setter(setter(Builder::faceDetail)).constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASONS_FIELD,
            FACE_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> reasons;

    private final FaceDetail faceDetail;

    private UnindexedFace(BuilderImpl builder) {
        this.reasons = builder.reasons;
        this.faceDetail = builder.faceDetail;
    }

    /**
     * <p>
     * An array of reasons that specify why a face wasn't indexed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from
     * the camera.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
     * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_BRIGHTNESS - The image is too dark.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_SHARPNESS - The image is too blurry.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_CONFIDENCE - The face was detected with a low confidence.
     * </p>
     * </li>
     * <li>
     * <p>
     * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of reasons that specify why a face wasn't indexed. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
     *         from the camera.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
     *         <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_BRIGHTNESS - The image is too dark.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_SHARPNESS - The image is too blurry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_CONFIDENCE - The face was detected with a low confidence.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SMALL_BOUNDING_BOX - The bounding box around the face is too small.
     *         </p>
     *         </li>
     */
    public List<Reason> reasons() {
        return ReasonsCopier.copyStringToEnum(reasons);
    }

    /**
     * Returns true if the Reasons property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of reasons that specify why a face wasn't indexed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from
     * the camera.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
     * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_BRIGHTNESS - The image is too dark.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_SHARPNESS - The image is too blurry.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOW_CONFIDENCE - The face was detected with a low confidence.
     * </p>
     * </li>
     * <li>
     * <p>
     * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of reasons that specify why a face wasn't indexed. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
     *         from the camera.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
     *         <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_BRIGHTNESS - The image is too dark.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_SHARPNESS - The image is too blurry.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOW_CONFIDENCE - The face was detected with a low confidence.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SMALL_BOUNDING_BOX - The bounding box around the face is too small.
     *         </p>
     *         </li>
     */
    public List<String> reasonsAsStrings() {
        return reasons;
    }

    /**
     * <p>
     * The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index.
     * </p>
     * 
     * @return The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index.
     */
    public FaceDetail faceDetail() {
        return faceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasonsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(faceDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnindexedFace)) {
            return false;
        }
        UnindexedFace other = (UnindexedFace) obj;
        return Objects.equals(reasonsAsStrings(), other.reasonsAsStrings()) && Objects.equals(faceDetail(), other.faceDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnindexedFace").add("Reasons", reasonsAsStrings()).add("FaceDetail", faceDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reasons":
            return Optional.ofNullable(clazz.cast(reasonsAsStrings()));
        case "FaceDetail":
            return Optional.ofNullable(clazz.cast(faceDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnindexedFace, T> g) {
        return obj -> g.apply((UnindexedFace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnindexedFace> {
        /**
         * <p>
         * An array of reasons that specify why a face wasn't indexed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
         * from the camera.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_BRIGHTNESS - The image is too dark.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_SHARPNESS - The image is too blurry.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_CONFIDENCE - The face was detected with a low confidence.
         * </p>
         * </li>
         * <li>
         * <p>
         * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasons
         *        An array of reasons that specify why a face wasn't indexed. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far
         *        away from the camera.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         *        <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_BRIGHTNESS - The image is too dark.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_SHARPNESS - The image is too blurry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_CONFIDENCE - The face was detected with a low confidence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(Collection<String> reasons);

        /**
         * <p>
         * An array of reasons that specify why a face wasn't indexed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
         * from the camera.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_BRIGHTNESS - The image is too dark.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_SHARPNESS - The image is too blurry.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_CONFIDENCE - The face was detected with a low confidence.
         * </p>
         * </li>
         * <li>
         * <p>
         * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasons
         *        An array of reasons that specify why a face wasn't indexed. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far
         *        away from the camera.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         *        <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_BRIGHTNESS - The image is too dark.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_SHARPNESS - The image is too blurry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_CONFIDENCE - The face was detected with a low confidence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(String... reasons);

        /**
         * <p>
         * An array of reasons that specify why a face wasn't indexed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
         * from the camera.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_BRIGHTNESS - The image is too dark.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_SHARPNESS - The image is too blurry.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_CONFIDENCE - The face was detected with a low confidence.
         * </p>
         * </li>
         * <li>
         * <p>
         * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasons
         *        An array of reasons that specify why a face wasn't indexed. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far
         *        away from the camera.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         *        <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_BRIGHTNESS - The image is too dark.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_SHARPNESS - The image is too blurry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_CONFIDENCE - The face was detected with a low confidence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<Reason> reasons);

        /**
         * <p>
         * An array of reasons that specify why a face wasn't indexed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away
         * from the camera.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         * <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_BRIGHTNESS - The image is too dark.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_SHARPNESS - The image is too blurry.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOW_CONFIDENCE - The face was detected with a low confidence.
         * </p>
         * </li>
         * <li>
         * <p>
         * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasons
         *        An array of reasons that specify why a face wasn't indexed. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far
         *        away from the camera.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the
         *        <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_BRIGHTNESS - The image is too dark.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_SHARPNESS - The image is too blurry.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOW_CONFIDENCE - The face was detected with a low confidence.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Reason... reasons);

        /**
         * <p>
         * The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index.
         * </p>
         * 
         * @param faceDetail
         *        The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't
         *        index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetail(FaceDetail faceDetail);

        /**
         * <p>
         * The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #faceDetail(FaceDetail)}.
         * 
         * @param faceDetail
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceDetail(FaceDetail)
         */
        default Builder faceDetail(Consumer<FaceDetail.Builder> faceDetail) {
            return faceDetail(FaceDetail.builder().applyMutation(faceDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UnindexedFace model) {
            reasonsWithStrings(model.reasons);
            faceDetail(model.faceDetail);
        }

        public final Collection<String> getReasonsAsStrings() {
            return reasons;
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = ReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String... reasons) {
            reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<Reason> reasons) {
            this.reasons = ReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Reason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        public final void setReasonsWithStrings(Collection<String> reasons) {
            this.reasons = ReasonsCopier.copy(reasons);
        }

        public final FaceDetail.Builder getFaceDetail() {
            return faceDetail != null ? faceDetail.toBuilder() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        @Override
        public UnindexedFace build() {
            return new UnindexedFace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
