/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only
 * making a determination of the physical appearance of a person's face. It is not a determination of the person’s
 * internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face
 * might not be sad emotionally.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Emotion implements SdkPojo, Serializable, ToCopyableBuilder<Emotion.Builder, Emotion> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Emotion::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(Emotion::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float confidence;

    private Emotion(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Type of emotion detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EmotionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of emotion detected.
     * @see EmotionName
     */
    public EmotionName type() {
        return EmotionName.fromValue(type);
    }

    /**
     * <p>
     * Type of emotion detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EmotionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of emotion detected.
     * @see EmotionName
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Emotion)) {
            return false;
        }
        Emotion other = (Emotion) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Emotion").add("Type", typeAsString()).add("Confidence", confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Emotion, T> g) {
        return obj -> g.apply((Emotion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Emotion> {
        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @see EmotionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(String type);

        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @see EmotionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(EmotionName type);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Emotion model) {
            type(model.type);
            confidence(model.confidence);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EmotionName type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Emotion build() {
            return new Emotion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
