/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID
 * that you assigned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Face implements SdkPojo, Serializable, ToCopyableBuilder<Face.Builder, Face> {
    private static final SdkField<String> FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Face::faceId)).setter(setter(Builder::faceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .getter(getter(Face::boundingBox)).setter(setter(Builder::boundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Face::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> EXTERNAL_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Face::externalImageId)).setter(setter(Builder::externalImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalImageId").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(Face::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_ID_FIELD,
            BOUNDING_BOX_FIELD, IMAGE_ID_FIELD, EXTERNAL_IMAGE_ID_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String faceId;

    private final BoundingBox boundingBox;

    private final String imageId;

    private final String externalImageId;

    private final Float confidence;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the face.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the face.
     */
    public String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the input image.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the input image.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Identifier that you assign to all the faces in the input image.
     * </p>
     * 
     * @return Identifier that you assign to all the faces in the input image.
     */
    public String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * Confidence level that the bounding box contains a face (and not a different object such as a tree).
     * </p>
     * 
     * @return Confidence level that the bounding box contains a face (and not a different object such as a tree).
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceId());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face) obj;
        return Objects.equals(faceId(), other.faceId()) && Objects.equals(boundingBox(), other.boundingBox())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(externalImageId(), other.externalImageId())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Face").add("FaceId", faceId()).add("BoundingBox", boundingBox()).add("ImageId", imageId())
                .add("ExternalImageId", externalImageId()).add("Confidence", confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceId":
            return Optional.ofNullable(clazz.cast(faceId()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ExternalImageId":
            return Optional.ofNullable(clazz.cast(externalImageId()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Face, T> g) {
        return obj -> g.apply((Face) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Face> {
        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the face.
         * </p>
         * 
         * @param faceId
         *        Unique identifier that Amazon Rekognition assigns to the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the input image.
         * </p>
         * 
         * @param imageId
         *        Unique identifier that Amazon Rekognition assigns to the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Identifier that you assign to all the faces in the input image.
         * </p>
         * 
         * @param externalImageId
         *        Identifier that you assign to all the faces in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * </p>
         * 
         * @param confidence
         *        Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String faceId;

        private BoundingBox boundingBox;

        private String imageId;

        private String externalImageId;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            faceId(model.faceId);
            boundingBox(model.boundingBox);
            imageId(model.imageId);
            externalImageId(model.externalImageId);
            confidence(model.confidence);
        }

        public final String getFaceId() {
            return faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Face build() {
            return new Face(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
