/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ComparedFace JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ComparedFaceUnmarshaller implements Unmarshaller<ComparedFace, JsonUnmarshallerContext> {

    public ComparedFace unmarshall(JsonUnmarshallerContext context) throws Exception {
        ComparedFace.Builder comparedFaceBuilder = ComparedFace.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BoundingBox", targetDepth)) {
                    context.nextToken();
                    comparedFaceBuilder.boundingBox(BoundingBoxUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    comparedFaceBuilder.confidence(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("Landmarks", targetDepth)) {
                    context.nextToken();
                    comparedFaceBuilder.landmarks(new ListUnmarshaller<Landmark>(LandmarkUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("Pose", targetDepth)) {
                    context.nextToken();
                    comparedFaceBuilder.pose(PoseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Quality", targetDepth)) {
                    context.nextToken();
                    comparedFaceBuilder.quality(ImageQualityUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return comparedFaceBuilder.build();
    }

    private static final ComparedFaceUnmarshaller INSTANCE = new ComparedFaceUnmarshaller();

    public static ComparedFaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
