/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.transform.S3ObjectUnmarshaller;

public class ImageUnmarshaller
implements Unmarshaller<Image, JsonUnmarshallerContext> {
    private static final ImageUnmarshaller INSTANCE = new ImageUnmarshaller();

    public Image unmarshall(JsonUnmarshallerContext context) throws Exception {
        Image.Builder imageBuilder = Image.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Bytes", targetDepth)) {
                    context.nextToken();
                    imageBuilder.bytes((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Object", targetDepth)) {
                    context.nextToken();
                    imageBuilder.s3Object(S3ObjectUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Image)imageBuilder.build();
    }

    public static ImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

