/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchFacesRequest> {
    private final String collectionId;
    private final String faceId;
    private final Integer maxFaces;
    private final Float faceMatchThreshold;

    private SearchFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.faceId = builder.faceId;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String faceId() {
        return this.faceId;
    }

    public Integer maxFaces() {
        return this.maxFaces;
    }

    public Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceMatchThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesRequest)) {
            return false;
        }
        SearchFacesRequest other = (SearchFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.maxFaces(), other.maxFaces()) && Objects.equals(this.faceMatchThreshold(), other.faceMatchThreshold());
    }

    public String toString() {
        return ToString.builder((String)"SearchFacesRequest").add("CollectionId", (Object)this.collectionId()).add("FaceId", (Object)this.faceId()).add("MaxFaces", (Object)this.maxFaces()).add("FaceMatchThreshold", (Object)this.faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.of(clazz.cast(this.collectionId()));
            }
            case "FaceId": {
                return Optional.of(clazz.cast(this.faceId()));
            }
            case "MaxFaces": {
                return Optional.of(clazz.cast(this.maxFaces()));
            }
            case "FaceMatchThreshold": {
                return Optional.of(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private String faceId;
        private Integer maxFaces;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesRequest model) {
            this.collectionId(model.collectionId);
            this.faceId(model.faceId);
            this.maxFaces(model.maxFaces);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final String getFaceId() {
            return this.faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesRequest build() {
            return new SearchFacesRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, SearchFacesRequest> {
        public Builder collectionId(String var1);

        public Builder faceId(String var1);

        public Builder maxFaces(Integer var1);

        public Builder faceMatchThreshold(Float var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

